/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.view.federation;

import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.mode.metadata.refresher.FederationMetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateViewStatement;

public final class CreateViewFederationMetaDataRefresher
implements FederationMetaDataRefresher<CreateViewStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String schemaName, DatabaseType databaseType, CreateViewStatement sqlStatement) {
        String viewName = TableRefreshUtils.getTableName(databaseType, sqlStatement.getView().getTableName().getIdentifier());
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName);
        alterSchemaMetaDataPOJO.getAlteredViews().add(new ShardingSphereView(viewName, sqlStatement.getViewDefinition()));
        metaDataManagerPersistService.alterSchemaMetaData(alterSchemaMetaDataPOJO);
    }

    @Override
    public Class<CreateViewStatement> getType() {
        return CreateViewStatement.class;
    }
}

