/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.opengauss.handler.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.AbstractDatabaseMetaDataExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.OpenGaussShowVariableExecutor;
import org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.OpenGaussSystemCatalogAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.PostgreSQLAdminExecutorCreator;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class OpenGaussAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final Set<String> SYSTEM_CATALOG_QUERY_EXPRESSIONS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> SYSTEM_CATALOG_TABLES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final PostgreSQLAdminExecutorCreator delegated = new PostgreSQLAdminExecutorCreator();

    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof ShowStatement) {
            return Optional.of(new OpenGaussShowVariableExecutor((ShowStatement)sqlStatement));
        }
        return Optional.empty();
    }

    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext, String sql, String databaseName, List<Object> parameters) {
        if (this.isSQLFederationSystemCatalogQuery(sqlStatementContext) || this.isSQLFederationSystemCatalogQueryExpressions(sqlStatementContext)) {
            return Optional.of(new OpenGaussSystemCatalogAdminQueryExecutor(sqlStatementContext, sql, databaseName, parameters));
        }
        if (this.isPassThroughSystemCatalogQuery(sqlStatementContext)) {
            return Optional.of(new AbstractDatabaseMetaDataExecutor.DefaultDatabaseMetaDataExecutor(sql, parameters));
        }
        return this.delegated.create(sqlStatementContext, sql, databaseName, parameters);
    }

    private boolean isSQLFederationSystemCatalogQuery(SQLStatementContext sqlStatementContext) {
        List tableNames = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getTableNames() : Collections.emptyList();
        return !tableNames.isEmpty() && SYSTEM_CATALOG_TABLES.containsAll(tableNames);
    }

    private boolean isSQLFederationSystemCatalogQueryExpressions(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext.getSqlStatement() instanceof SelectStatement)) {
            return false;
        }
        SelectStatement selectStatement = (SelectStatement)sqlStatementContext.getSqlStatement();
        Collection projections = selectStatement.getProjections().getProjections();
        return 1 == projections.size() && projections.iterator().next() instanceof ExpressionProjectionSegment && SYSTEM_CATALOG_QUERY_EXPRESSIONS.contains(((ExpressionProjectionSegment)projections.iterator().next()).getText());
    }

    private boolean isPassThroughSystemCatalogQuery(SQLStatementContext sqlStatementContext) {
        List tableNames = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getTableNames() : Collections.emptyList();
        return !tableNames.isEmpty() && (SystemSchemaManager.isSystemTable((String)"opengauss", (String)"information_schema", tableNames) || SystemSchemaManager.isSystemTable((String)"opengauss", (String)"pg_catalog", tableNames));
    }

    public String getDatabaseType() {
        return "openGauss";
    }

    static {
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("VERSION()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("opengauss_version()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("gs_password_deadline()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("intervaltonum()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("intervaltonum(gs_password_deadline())");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("gs_password_notifytime()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("pg_catalog.gs_password_deadline()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("pg_catalog.intervaltonum()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("pg_catalog.intervaltonum(pg_catalog.gs_password_deadline())");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("pg_catalog.gs_password_notifytime()");
        SYSTEM_CATALOG_TABLES.add("pg_class");
        SYSTEM_CATALOG_TABLES.add("pg_namespace");
        SYSTEM_CATALOG_TABLES.add("pg_database");
        SYSTEM_CATALOG_TABLES.add("pg_tables");
        SYSTEM_CATALOG_TABLES.add("pg_roles");
    }
}

