/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.node.path.rule.RuleNodePath;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterUniqueRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropUniqueRuleItem;

public final class UniqueRuleItemChangedHandler {
    private final ContextManager contextManager;

    public void handle(RuleNodePath ruleNodePath, String databaseName, String path, DataChangedEvent event) throws SQLException {
        String type = ruleNodePath.getRoot().getRuleType() + "." + path;
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            this.contextManager.getMetaDataContextManager().getRuleItemManager().alterRuleItem((AlterRuleItem)new AlterUniqueRuleItem(databaseName, event.getKey(), event.getValue(), type));
        } else if (DataChangedEvent.Type.DELETED == event.getType()) {
            this.contextManager.getMetaDataContextManager().getRuleItemManager().dropRuleItem((DropRuleItem)new DropUniqueRuleItem(databaseName, type));
        }
    }

    @Generated
    public UniqueRuleItemChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

