/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.logging.type.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.logging.logger.ShardingSphereAppender;
import org.apache.shardingsphere.logging.logger.ShardingSphereLogger;
import org.apache.shardingsphere.logging.spi.ShardingSphereLogBuilder;

public final class ShardingSphereLogbackBuilder
implements ShardingSphereLogBuilder<LoggerContext> {
    public Collection<ShardingSphereLogger> getDefaultLoggers(LoggerContext loggerContext) {
        return loggerContext.getLoggerList().stream().filter(this::isQualifiedLogger).map(each -> new ShardingSphereLogger(each.getName(), each.getLevel().levelStr, Boolean.valueOf(each.isAdditive()), each.iteratorForAppenders().hasNext() ? ((Appender)each.iteratorForAppenders().next()).getName() : null)).collect(Collectors.toList());
    }

    private boolean isQualifiedLogger(Logger logger) {
        return null != logger.getLevel() && !"ROOT".equalsIgnoreCase(logger.getName());
    }

    public Collection<ShardingSphereAppender> getDefaultAppenders(LoggerContext loggerContext) {
        return loggerContext.getLoggerList().stream().filter(this::isQualifiedLogger).map(each -> each.iteratorForAppenders().hasNext() ? this.getShardingSphereAppender((Appender)each.iteratorForAppenders().next()) : null).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new TreeSet<ShardingSphereAppender>(Comparator.comparing(ShardingSphereAppender::getAppenderName))));
    }

    private ShardingSphereAppender getShardingSphereAppender(Appender<?> appender) {
        String file = appender instanceof FileAppender ? ((FileAppender)appender).getFile() : null;
        return new ShardingSphereAppender(appender.getName(), appender.getClass().getName(), this.getAppenderPattern(appender), file);
    }

    private String getAppenderPattern(Appender<?> appender) {
        if (appender instanceof OutputStreamAppender) {
            OutputStreamAppender consoleAppender = (OutputStreamAppender)appender;
            LayoutWrappingEncoder encoder = (LayoutWrappingEncoder)consoleAppender.getEncoder();
            PatternLayoutBase layout = (PatternLayoutBase)encoder.getLayout();
            return layout.getPattern();
        }
        return "";
    }

    public Class<LoggerContext> getType() {
        return LoggerContext.class;
    }
}

