/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.failover;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.failover.FailoverNode;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobScheduleController;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingNode;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.base.LeaderExecutionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FailoverService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FailoverService.class);
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ShardingService shardingService;
    private final ConfigurationService configService;

    public FailoverService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public void setCrashedFailoverFlag(int item) {
        if (!this.isFailoverAssigned(item)) {
            this.jobNodeStorage.createJobNodeIfNeeded(FailoverNode.getItemsNode(item));
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getRunningNode(item));
        }
    }

    public void setCrashedFailoverFlagDirectly(int item) {
        this.jobNodeStorage.createJobNodeIfNeeded(FailoverNode.getItemsNode(item));
    }

    private boolean isFailoverAssigned(Integer item) {
        return this.jobNodeStorage.isJobNodeExisted(FailoverNode.getExecutionFailoverNode(item));
    }

    public void failoverIfNecessary() {
        if (this.needFailover()) {
            this.jobNodeStorage.executeInLeader("leader/failover/latch", new FailoverLeaderExecutionCallback());
        }
    }

    private boolean needFailover() {
        return this.jobNodeStorage.isJobNodeExisted("leader/failover/items") && !this.jobNodeStorage.getJobNodeChildrenKeys("leader/failover/items").isEmpty() && !JobRegistry.getInstance().isJobRunning(this.jobName);
    }

    public void updateFailoverComplete(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getExecutionFailoverNode(each));
            this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getExecutingFailoverNode(each));
        }
    }

    public List<Integer> getFailoverItems(String jobInstanceId) {
        List<String> items = this.jobNodeStorage.getJobNodeChildrenKeys("sharding");
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (String each : items) {
            int item = Integer.parseInt(each);
            String node = FailoverNode.getExecutionFailoverNode(item);
            if (!this.jobNodeStorage.isJobNodeExisted(node) || !jobInstanceId.equals(this.jobNodeStorage.getJobNodeDataDirectly(node))) continue;
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    public List<Integer> getFailoveringItems(String jobInstanceId) {
        List<String> items = this.jobNodeStorage.getJobNodeChildrenKeys("sharding");
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (String each : items) {
            int item = Integer.parseInt(each);
            String node = FailoverNode.getExecutingFailoverNode(item);
            if (!this.jobNodeStorage.isJobNodeExisted(node) || !jobInstanceId.equals(this.jobNodeStorage.getJobNodeDataDirectly(node))) continue;
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    public List<Integer> getLocalFailoverItems() {
        if (JobRegistry.getInstance().isShutdown(this.jobName)) {
            return Collections.emptyList();
        }
        return this.getFailoverItems(JobRegistry.getInstance().getJobInstance(this.jobName).getJobInstanceId());
    }

    public List<Integer> getLocalTakeOffItems() {
        List<Integer> shardingItems = this.shardingService.getLocalShardingItems();
        ArrayList<Integer> result = new ArrayList<Integer>(shardingItems.size());
        for (int each : shardingItems) {
            if (!this.jobNodeStorage.isJobNodeExisted(FailoverNode.getExecutionFailoverNode(each))) continue;
            result.add(each);
        }
        return result;
    }

    public Map<Integer, JobInstance> getAllFailoveringItems() {
        int shardingTotalCount = this.configService.load(true).getShardingTotalCount();
        LinkedHashMap<Integer, JobInstance> result = new LinkedHashMap<Integer, JobInstance>(shardingTotalCount, 1.0f);
        for (int i = 0; i < shardingTotalCount; ++i) {
            String data = this.jobNodeStorage.getJobNodeData(FailoverNode.getExecutingFailoverNode(i));
            if (Strings.isNullOrEmpty((String)data)) continue;
            result.put(i, new JobInstance(data));
        }
        return result;
    }

    public void clearFailoveringItem(int item) {
        this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getExecutingFailoverNode(item));
    }

    public void removeFailoverInfo() {
        for (String each : this.jobNodeStorage.getJobNodeChildrenKeys("sharding")) {
            this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getExecutionFailoverNode(Integer.parseInt(each)));
        }
    }

    class FailoverLeaderExecutionCallback
    implements LeaderExecutionCallback {
        FailoverLeaderExecutionCallback() {
        }

        public void execute() {
            if (JobRegistry.getInstance().isShutdown(FailoverService.this.jobName) || !FailoverService.this.needFailover()) {
                return;
            }
            int crashedItem = Integer.parseInt(FailoverService.this.jobNodeStorage.getJobNodeChildrenKeys("leader/failover/items").get(0));
            log.debug("Failover job '{}' begin, crashed item '{}'", (Object)FailoverService.this.jobName, (Object)crashedItem);
            FailoverService.this.jobNodeStorage.fillEphemeralJobNode(FailoverNode.getExecutionFailoverNode(crashedItem), JobRegistry.getInstance().getJobInstance(FailoverService.this.jobName).getJobInstanceId());
            FailoverService.this.jobNodeStorage.fillJobNode(FailoverNode.getExecutingFailoverNode(crashedItem), JobRegistry.getInstance().getJobInstance(FailoverService.this.jobName).getJobInstanceId());
            FailoverService.this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getItemsNode(crashedItem));
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(FailoverService.this.jobName);
            if (null != jobScheduleController) {
                jobScheduleController.triggerJob();
            }
        }
    }
}

