/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.datasource;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.util.reflection.ReflectionUtils;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionWrapper;
import org.apache.shardingsphere.transaction.xa.jta.datasource.properties.XADataSourceDefinition;
import org.apache.shardingsphere.transaction.xa.jta.datasource.swapper.DataSourceSwapper;
import org.apache.shardingsphere.transaction.xa.spi.SingleXAResource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManagerProvider;

public final class XATransactionDataSource
implements AutoCloseable {
    private static final Set<String> CONTAINER_DATASOURCE_NAMES = new HashSet<String>(Arrays.asList("AtomikosDataSourceBean", "BasicManagedDataSource"));
    private final ThreadLocal<Map<Transaction, Connection>> enlistedTransactions = ThreadLocal.withInitial(HashMap::new);
    private final String resourceName;
    private final DataSource dataSource;
    private XADataSource xaDataSource;
    private XAConnectionWrapper xaConnectionWrapper;
    private XATransactionManagerProvider xaTransactionManagerProvider;

    public XATransactionDataSource(DatabaseType databaseType, String resourceName, DataSource dataSource, XATransactionManagerProvider xaTransactionManagerProvider) {
        this.resourceName = resourceName;
        this.dataSource = dataSource;
        if (!CONTAINER_DATASOURCE_NAMES.contains(dataSource.getClass().getSimpleName())) {
            this.xaDataSource = new DataSourceSwapper((XADataSourceDefinition)DatabaseTypedSPILoader.getService(XADataSourceDefinition.class, (DatabaseType)databaseType)).swap(dataSource);
            this.xaConnectionWrapper = (XAConnectionWrapper)DatabaseTypedSPILoader.getService(XAConnectionWrapper.class, (DatabaseType)databaseType);
            this.xaTransactionManagerProvider = xaTransactionManagerProvider;
            xaTransactionManagerProvider.registerRecoveryResource(resourceName, this.xaDataSource);
        }
    }

    public Connection getConnection() throws SQLException, SystemException, RollbackException {
        if (CONTAINER_DATASOURCE_NAMES.contains(this.dataSource.getClass().getSimpleName())) {
            return this.dataSource.getConnection();
        }
        final Transaction transaction = this.xaTransactionManagerProvider.getTransactionManager().getTransaction();
        if (!this.enlistedTransactions.get().containsKey(transaction)) {
            Connection connection = this.dataSource.getConnection();
            XAConnection xaConnection = this.xaConnectionWrapper.wrap(this.xaDataSource, connection);
            transaction.enlistResource((XAResource)new SingleXAResource(this.resourceName, xaConnection.getXAResource()));
            transaction.registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                    ((Map)XATransactionDataSource.this.enlistedTransactions.get()).remove(transaction);
                }

                public void afterCompletion(int status) {
                    ((Map)XATransactionDataSource.this.enlistedTransactions.get()).clear();
                }
            });
            this.enlistedTransactions.get().put(transaction, connection);
        }
        return this.enlistedTransactions.get().get(transaction);
    }

    @Override
    public void close() {
        if (CONTAINER_DATASOURCE_NAMES.contains(this.dataSource.getClass().getSimpleName())) {
            this.close(this.dataSource);
        } else {
            this.xaTransactionManagerProvider.removeRecoveryResource(this.resourceName, this.xaDataSource);
        }
        this.enlistedTransactions.remove();
    }

    private void close(DataSource dataSource) {
        try {
            ReflectionUtils.invokeMethod((Method)dataSource.getClass().getDeclaredMethod("close", new Class[0]), (Object)dataSource, (Object[])new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

