/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.YamlShardingStrategyConfigurationSwapper;

public final class DefaultDatabaseShardingStrategyChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, ShardingStrategyConfiguration> {
    public ShardingStrategyConfiguration swapRuleItemConfiguration(AlterRuleItem alterRuleItem, String yamlContent) {
        return new YamlShardingStrategyConfigurationSwapper().swapToObject((YamlShardingStrategyConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlShardingStrategyConfiguration.class));
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItem alterRuleItem, ShardingRuleConfiguration currentRuleConfig, ShardingStrategyConfiguration toBeChangedItemConfig) {
        currentRuleConfig.setDefaultDatabaseShardingStrategy(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItem dropRuleItem, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultDatabaseShardingStrategy(null);
    }

    public String getType() {
        return "sharding.default_database_strategy";
    }
}

