/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.converter;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.converter.ReadwriteSplittingConvertDistSQLConstants;

public final class ReadwriteSplittingRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<ReadwriteSplittingRuleConfiguration> {
    public String convert(ReadwriteSplittingRuleConfiguration ruleConfig) {
        return ruleConfig.getDataSourceGroups().isEmpty() ? "" : "CREATE READWRITE_SPLITTING RULE" + this.convertReadWriteSplittingRules(ruleConfig) + ";";
    }

    private String convertReadWriteSplittingRules(ReadwriteSplittingRuleConfiguration ruleConfig) {
        return ruleConfig.getDataSourceGroups().stream().map(each -> this.convertReadWriteSplittingRule((ReadwriteSplittingDataSourceGroupRuleConfiguration)each, ruleConfig.getLoadBalancers())).collect(Collectors.joining(","));
    }

    private String convertReadWriteSplittingRule(ReadwriteSplittingDataSourceGroupRuleConfiguration dataSourceGroupRuleConfig, Map<String, AlgorithmConfiguration> loadBalancers) {
        String readDataSourceNames = this.convertReadDataSourceNames(dataSourceGroupRuleConfig.getReadDataSourceNames());
        String transactionalReadQueryStrategy = dataSourceGroupRuleConfig.getTransactionalReadQueryStrategy().name();
        String loadBalancerType = this.convertLoadBalancerType(loadBalancers.get(dataSourceGroupRuleConfig.getLoadBalancerName()));
        return String.format(ReadwriteSplittingConvertDistSQLConstants.READWRITE_SPLITTING_RULE, dataSourceGroupRuleConfig.getName(), dataSourceGroupRuleConfig.getWriteDataSourceName(), readDataSourceNames, transactionalReadQueryStrategy, loadBalancerType);
    }

    private String convertReadDataSourceNames(Collection<String> readDataSourceNames) {
        return readDataSourceNames.stream().map(each -> String.format("%s", each)).collect(Collectors.joining(","));
    }

    private String convertLoadBalancerType(AlgorithmConfiguration algorithmConfig) {
        String loadBalancerType = AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)algorithmConfig);
        return Strings.isNullOrEmpty((String)loadBalancerType) ? "" : "," + System.lineSeparator() + loadBalancerType;
    }

    public Class<ReadwriteSplittingRuleConfiguration> getType() {
        return ReadwriteSplittingRuleConfiguration.class;
    }
}

