/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.util;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.validate.DistSQLDataSourcePoolPropertiesValidator;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationCheckEngine;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.ShardingSphereSQLException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.DatabaseCreateExistsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.MissingRequiredDatabaseException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.StorageUnitsOperateException;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapCreator;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRuleBuilder;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.YamlConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDataSourceConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyDataSourceConfigurationSwapper;

public final class YamlDatabaseConfigurationImportExecutor {
    private final YamlProxyDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlProxyDataSourceConfigurationSwapper();
    private final DistSQLDataSourcePoolPropertiesValidator validateHandler = new DistSQLDataSourcePoolPropertiesValidator();
    private final ContextManager contextManager;

    public void importDatabaseConfiguration(YamlProxyDatabaseConfiguration yamlConfig) throws SQLException {
        String databaseName = yamlConfig.getDatabaseName();
        this.checkDatabase(databaseName);
        this.checkDataSources(databaseName, yamlConfig.getDataSources());
        this.addDatabase(databaseName);
        try {
            this.importDataSources(databaseName, yamlConfig.getDataSources());
            this.importRules(databaseName, yamlConfig.getRules());
        }
        catch (ShardingSphereSQLException ex) {
            this.dropDatabase(databaseName);
            throw ex;
        }
    }

    private void checkDataSources(String databaseName, Map<String, YamlProxyDataSourceConfiguration> dataSources) {
        ShardingSpherePreconditions.checkNotEmpty(dataSources, () -> new EmptyStorageUnitException(databaseName));
    }

    private void checkDatabase(String databaseName) {
        ShardingSpherePreconditions.checkNotEmpty((String)databaseName, MissingRequiredDatabaseException::new);
        ShardingSpherePreconditions.checkState((!this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(databaseName) ? 1 : 0) != 0, () -> new DatabaseCreateExistsException(databaseName));
    }

    private void addDatabase(String databaseName) throws SQLException {
        this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().createDatabase(databaseName);
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(Collections.emptyMap(), (ConfigurationProperties)this.contextManager.getMetaDataContexts().getMetaData().getProps());
        this.contextManager.getMetaDataContexts().getMetaData().addDatabase(databaseName, protocolType, this.contextManager.getMetaDataContexts().getMetaData().getProps());
    }

    private void importDataSources(String databaseName, Map<String, YamlProxyDataSourceConfiguration> yamlDataSourceMap) {
        LinkedHashMap<String, DataSourcePoolProperties> propsMap = new LinkedHashMap<String, DataSourcePoolProperties>(yamlDataSourceMap.size(), 1.0f);
        for (Map.Entry<String, YamlProxyDataSourceConfiguration> entry : yamlDataSourceMap.entrySet()) {
            DataSourceConfiguration dataSourceConfig = this.dataSourceConfigSwapper.swap(entry.getValue());
            propsMap.put(entry.getKey(), DataSourcePoolPropertiesCreator.create((DataSourceConfiguration)dataSourceConfig));
        }
        this.validateHandler.validate(propsMap);
        try {
            this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().registerStorageUnits(databaseName, propsMap);
        }
        catch (SQLException ex) {
            throw new StorageUnitsOperateException("import", propsMap.keySet(), (Exception)ex);
        }
        Map storageUnits = this.contextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData().getStorageUnits();
        Map toBeAddedStorageNode = StorageUnitNodeMapCreator.create(propsMap);
        for (Map.Entry entry : propsMap.entrySet()) {
            storageUnits.put((String)entry.getKey(), new StorageUnit((StorageNode)toBeAddedStorageNode.get(entry.getKey()), (DataSourcePoolProperties)entry.getValue(), DataSourcePoolCreator.create((DataSourcePoolProperties)((DataSourcePoolProperties)entry.getValue()))));
        }
    }

    private void importRules(String databaseName, Collection<YamlRuleConfiguration> yamlRuleConfigs) {
        if (null == yamlRuleConfigs || yamlRuleConfigs.isEmpty()) {
            return;
        }
        LinkedList ruleConfigs = new LinkedList();
        MetaDataContexts metaDataContexts = this.contextManager.getMetaDataContexts();
        ShardingSphereDatabase database = metaDataContexts.getMetaData().getDatabase(databaseName);
        this.swapToRuleConfigs(yamlRuleConfigs).values().forEach(each -> this.addRule(ruleConfigs, (RuleConfiguration)each, database));
        this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDatabaseRulePersistService().persist(metaDataContexts.getMetaData().getDatabase(databaseName).getName(), ruleConfigs);
    }

    private void addRule(Collection<RuleConfiguration> ruleConfigs, RuleConfiguration ruleConfig, ShardingSphereDatabase database) {
        RuleConfigurationCheckEngine.check((RuleConfiguration)ruleConfig, (ShardingSphereDatabase)database);
        ruleConfigs.add(ruleConfig);
        database.getRuleMetaData().getRules().add(this.buildRule(ruleConfig, database));
    }

    private ShardingSphereRule buildRule(RuleConfiguration ruleConfig, ShardingSphereDatabase database) {
        DatabaseRuleBuilder ruleBuilder = (DatabaseRuleBuilder)OrderedSPILoader.getServices(DatabaseRuleBuilder.class, Collections.singleton(ruleConfig)).get(ruleConfig);
        ComputeNodeInstanceContext computeNodeInstanceContext = this.contextManager.getComputeNodeInstanceContext();
        return ruleBuilder.build(ruleConfig, database.getName(), database.getProtocolType(), database.getResourceMetaData(), database.getRuleMetaData().getRules(), computeNodeInstanceContext);
    }

    private Map<Integer, RuleConfiguration> swapToRuleConfigs(Collection<YamlRuleConfiguration> yamlRuleConfigs) {
        TreeMap<Integer, RuleConfiguration> result = new TreeMap<Integer, RuleConfiguration>(Comparator.reverseOrder());
        for (YamlRuleConfiguration each : yamlRuleConfigs) {
            YamlRuleConfigurationSwapper swapper = (YamlRuleConfigurationSwapper)OrderedSPILoader.getServicesByClass(YamlRuleConfigurationSwapper.class, Collections.singleton(each.getRuleConfigurationType())).get(each.getRuleConfigurationType());
            result.put(swapper.getOrder(), (RuleConfiguration)swapper.swapToObject((YamlConfiguration)each));
        }
        return result;
    }

    private void dropDatabase(String databaseName) throws SQLException {
        this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().dropDatabase(databaseName);
    }

    @Generated
    public YamlDatabaseConfigurationImportExecutor(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

