/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.transaction;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.database.mysql.type.MySQLDatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.transaction.InTransactionException;
import org.apache.shardingsphere.proxy.backend.connector.TransactionManager;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.BackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.SetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.tcl.MySQLSetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.opengauss.tcl.OpenGaussCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.opengauss.tcl.OpenGaussRollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.tcl.PostgreSQLCommitStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.tcl.PostgreSQLRollbackStatement;
import org.apache.shardingsphere.transaction.core.TransactionOperationType;

public final class TransactionBackendHandler
implements ProxyBackendHandler {
    private final TCLStatement tclStatement;
    private final TransactionOperationType operationType;
    private final TransactionManager backendTransactionManager;
    private final ConnectionSession connectionSession;

    public TransactionBackendHandler(TCLStatement tclStatement, TransactionOperationType operationType, ConnectionSession connectionSession) {
        this.tclStatement = tclStatement;
        this.operationType = operationType;
        this.connectionSession = connectionSession;
        this.backendTransactionManager = new BackendTransactionManager(connectionSession.getDatabaseConnectionManager());
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        switch (this.operationType) {
            case BEGIN: {
                this.handleBegin();
                break;
            }
            case SAVEPOINT: {
                this.handleSavepoint();
                break;
            }
            case ROLLBACK_TO_SAVEPOINT: {
                this.handleRollbackToSavepoint();
                break;
            }
            case RELEASE_SAVEPOINT: {
                this.handleReleaseSavepoint();
                break;
            }
            case COMMIT: {
                SQLStatement sqlStatement = this.getSQLStatementByCommit();
                this.backendTransactionManager.commit();
                return new UpdateResponseHeader(sqlStatement);
            }
            case ROLLBACK: {
                this.backendTransactionManager.rollback();
                break;
            }
            case SET_AUTOCOMMIT: {
                this.handleSetAutoCommit();
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException(this.operationType.name());
            }
        }
        return new UpdateResponseHeader((SQLStatement)this.tclStatement);
    }

    private void handleBegin() throws SQLException {
        if (this.connectionSession.getTransactionStatus().isInTransaction()) {
            if (this.connectionSession.getProtocolType() instanceof MySQLDatabaseType) {
                this.backendTransactionManager.commit();
            } else if (this.isSchemaSupportedDatabaseType()) {
                throw new InTransactionException();
            }
        }
        this.backendTransactionManager.begin();
    }

    private void handleSavepoint() throws SQLException {
        ShardingSpherePreconditions.checkState((this.connectionSession.getTransactionStatus().isInTransaction() || !this.isSchemaSupportedDatabaseType() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("SAVEPOINT can only be used in transaction blocks"));
        this.backendTransactionManager.setSavepoint(((SavepointStatement)this.tclStatement).getSavepointName());
    }

    private void handleRollbackToSavepoint() throws SQLException {
        ShardingSpherePreconditions.checkState((this.connectionSession.getTransactionStatus().isInTransaction() || !this.isSchemaSupportedDatabaseType() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("ROLLBACK TO SAVEPOINT can only be used in transaction blocks"));
        this.backendTransactionManager.rollbackTo((String)((RollbackStatement)this.tclStatement).getSavepointName().get());
    }

    private void handleReleaseSavepoint() throws SQLException {
        ShardingSpherePreconditions.checkState((this.connectionSession.getTransactionStatus().isInTransaction() || !this.isSchemaSupportedDatabaseType() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("RELEASE SAVEPOINT can only be used in transaction blocks"));
        this.backendTransactionManager.releaseSavepoint(((ReleaseSavepointStatement)this.tclStatement).getSavepointName());
    }

    private boolean isSchemaSupportedDatabaseType() {
        return new DatabaseTypeRegistry(this.connectionSession.getProtocolType()).getDialectDatabaseMetaData().getDefaultSchema().isPresent();
    }

    private SQLStatement getSQLStatementByCommit() {
        TCLStatement result = this.tclStatement;
        if (this.connectionSession.getConnectionContext().getTransactionContext().isExceptionOccur()) {
            if (this.tclStatement instanceof OpenGaussCommitStatement) {
                result = new OpenGaussRollbackStatement();
            } else if (this.tclStatement instanceof PostgreSQLCommitStatement) {
                result = new PostgreSQLRollbackStatement();
            }
        }
        return result;
    }

    private void handleSetAutoCommit() throws SQLException {
        if (this.tclStatement instanceof MySQLSetAutoCommitStatement) {
            this.handleMySQLSetAutoCommit();
        }
        this.connectionSession.setAutoCommit(((SetAutoCommitStatement)this.tclStatement).isAutoCommit());
    }

    private void handleMySQLSetAutoCommit() throws SQLException {
        MySQLSetAutoCommitStatement statement = (MySQLSetAutoCommitStatement)this.tclStatement;
        if (statement.isAutoCommit() && this.connectionSession.getTransactionStatus().isInTransaction()) {
            this.backendTransactionManager.commit();
        }
    }
}

