/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.ral.updatable.LabelComputeNodeStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.mode.manager.ContextManager;

@DistSQLExecutorClusterModeRequired
public final class LabelComputeNodeExecutor
implements DistSQLUpdateExecutor<LabelComputeNodeStatement> {
    public void executeUpdate(LabelComputeNodeStatement sqlStatement, ContextManager contextManager) throws SQLException {
        String instanceId = sqlStatement.getInstanceId();
        Optional computeNodeInstance = contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().find(instanceId);
        if (computeNodeInstance.isPresent()) {
            LinkedHashSet labels = new LinkedHashSet(sqlStatement.getLabels());
            if (!sqlStatement.isOverwrite()) {
                labels.addAll(((ComputeNodeInstance)computeNodeInstance.get()).getLabels());
            }
            contextManager.getPersistServiceFacade().getComputeNodePersistService().persistLabels(instanceId, new LinkedList(labels));
        }
    }

    public Class<LabelComputeNodeStatement> getType() {
        return LabelComputeNodeStatement.class;
    }
}

