/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.ral.updatable.ImportMetaDataStatement;
import org.apache.shardingsphere.infra.exception.generic.FileIOException;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedClusterInfo;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedMetaData;
import org.apache.shardingsphere.proxy.backend.util.MetaDataImportExecutor;

public final class ImportMetaDataExecutor
implements DistSQLUpdateExecutor<ImportMetaDataStatement> {
    public void executeUpdate(ImportMetaDataStatement sqlStatement, ContextManager contextManager) throws SQLException {
        String jsonMetaDataConfig = sqlStatement.getFilePath().isPresent() ? this.getMetaDataFromFile(sqlStatement) : this.getMetaDataFromConsole(sqlStatement);
        ExportedClusterInfo exportedClusterInfo = (ExportedClusterInfo)JsonUtils.fromJsonString((String)jsonMetaDataConfig, ExportedClusterInfo.class);
        ExportedMetaData exportedMetaData = exportedClusterInfo.getMetaData();
        new MetaDataImportExecutor(contextManager).importClusterConfigurations(exportedMetaData);
    }

    private String getMetaDataFromFile(ImportMetaDataStatement sqlStatement) {
        File file = new File((String)sqlStatement.getFilePath().get());
        try {
            return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException ignore) {
            throw new FileIOException(file);
        }
    }

    private String getMetaDataFromConsole(ImportMetaDataStatement sqlStatement) {
        return new String(Base64.decodeBase64((String)sqlStatement.getMetaDataValue()));
    }

    public Class<ImportMetaDataStatement> getType() {
        return ImportMetaDataStatement.class;
    }
}

