/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.database;

import com.google.common.base.Strings;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.DatabaseDropNotExistsException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropDatabaseStatement;

public final class DropDatabaseBackendHandler
implements ProxyBackendHandler {
    private final DropDatabaseStatement sqlStatement;
    private final ConnectionSession connectionSession;

    @Override
    public ResponseHeader execute() throws SQLException {
        this.check(this.sqlStatement, this.connectionSession.getConnectionContext().getGrantee());
        if (this.isDropCurrentDatabase(this.sqlStatement.getDatabaseName())) {
            this.checkSupportedDropCurrentDatabase(this.connectionSession);
            this.connectionSession.setCurrentDatabaseName(null);
        }
        if (ProxyContext.getInstance().databaseExists(this.sqlStatement.getDatabaseName())) {
            ProxyContext.getInstance().getContextManager().getPersistServiceFacade().getMetaDataManagerPersistService().dropDatabase(this.sqlStatement.getDatabaseName());
        }
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private void check(DropDatabaseStatement sqlStatement, Grantee grantee) {
        String databaseName = sqlStatement.getDatabaseName().toLowerCase();
        AuthorityRule authorityRule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        AuthorityChecker authorityChecker = new AuthorityChecker(authorityRule, grantee);
        ShardingSpherePreconditions.checkState((boolean)authorityChecker.isAuthorized(databaseName), () -> new UnknownDatabaseException(databaseName));
        ShardingSpherePreconditions.checkState((sqlStatement.isIfExists() || ProxyContext.getInstance().databaseExists(databaseName) ? 1 : 0) != 0, () -> new DatabaseDropNotExistsException(databaseName));
    }

    private boolean isDropCurrentDatabase(String databaseName) {
        return !Strings.isNullOrEmpty((String)this.connectionSession.getUsedDatabaseName()) && this.connectionSession.getUsedDatabaseName().equals(databaseName);
    }

    private void checkSupportedDropCurrentDatabase(ConnectionSession connectionSession) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(connectionSession.getProtocolType()).getDialectDatabaseMetaData();
        ShardingSpherePreconditions.checkState((!dialectDatabaseMetaData.getDefaultSchema().isPresent() ? 1 : 0) != 0, () -> new UnsupportedOperationException("cannot drop the currently open database"));
    }

    @Generated
    public DropDatabaseBackendHandler(DropDatabaseStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }
}

