/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnector;
import org.apache.shardingsphere.proxy.backend.connector.sane.SaneQueryResultEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public abstract class ProxyJDBCExecutorCallback
extends JDBCExecutorCallback<ExecuteResult> {
    private final DatabaseConnector databaseConnector;
    private final boolean isReturnGeneratedKeys;
    private final boolean fetchMetaData;
    private boolean hasMetaData;

    protected ProxyJDBCExecutorCallback(DatabaseType protocolType, ResourceMetaData resourceMetaData, SQLStatement sqlStatement, DatabaseConnector databaseConnector, boolean isReturnGeneratedKeys, boolean isExceptionThrown, boolean fetchMetaData) {
        super(protocolType, resourceMetaData, sqlStatement, isExceptionThrown);
        this.databaseConnector = databaseConnector;
        this.isReturnGeneratedKeys = isReturnGeneratedKeys;
        this.fetchMetaData = fetchMetaData;
    }

    public ExecuteResult executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
        this.hasMetaData = this.fetchMetaData && !this.hasMetaData;
        this.databaseConnector.add(statement);
        if (this.execute(sql, statement, this.isReturnGeneratedKeys)) {
            ResultSet resultSet = statement.getResultSet();
            this.databaseConnector.add(resultSet);
            return this.createQueryResult(resultSet, connectionMode, storageType);
        }
        return new UpdateResult(Math.max(statement.getUpdateCount(), 0), this.isReturnGeneratedKeys ? this.getGeneratedKey(statement) : 0L);
    }

    protected abstract boolean execute(String var1, Statement var2, boolean var3) throws SQLException;

    private QueryResult createQueryResult(ResultSet resultSet, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
        return ConnectionMode.MEMORY_STRICTLY == connectionMode ? new JDBCStreamQueryResult(resultSet) : new JDBCMemoryQueryResult(resultSet, storageType);
    }

    private long getGeneratedKey(Statement statement) throws SQLException {
        try {
            ResultSet resultSet = statement.getGeneratedKeys();
            return resultSet.next() ? this.getGeneratedKeyIfInteger(resultSet) : 0L;
        }
        catch (SQLFeatureNotSupportedException ignore) {
            return 0L;
        }
    }

    private long getGeneratedKeyIfInteger(ResultSet resultSet) throws SQLException {
        switch (resultSet.getMetaData().getColumnType(1)) {
            case -5: 
            case 4: 
            case 5: {
                return resultSet.getLong(1);
            }
        }
        return 0L;
    }

    protected final Optional<ExecuteResult> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
        return new SaneQueryResultEngine(this.getProtocolTypeType()).getSaneQueryResult(sqlStatement, ex);
    }

    private DatabaseType getProtocolTypeType() {
        DatabaseType configuredDatabaseType = (DatabaseType)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        if (null != configuredDatabaseType) {
            return configuredDatabaseType;
        }
        if (ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getAllDatabases().isEmpty()) {
            return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL");
        }
        return ((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getAllDatabases().iterator().next()).getProtocolType();
    }
}

