/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.executor;

import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnector;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.ProxyJDBCExecutorCallbackFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class ProxyJDBCExecutor {
    private final String type;
    private final ConnectionSession connectionSession;
    private final DatabaseConnector databaseConnector;
    private final JDBCExecutor jdbcExecutor;
    private final ProcessEngine processEngine = new ProcessEngine();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecuteResult> execute(QueryContext queryContext, ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, boolean isReturnGeneratedKeys, boolean isExceptionThrown) throws SQLException {
        try {
            MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
            ShardingSphereDatabase database = metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName());
            DatabaseType protocolType = database.getProtocolType();
            this.processEngine.executeSQL(executionGroupContext, queryContext);
            SQLStatementContext context = queryContext.getSqlStatementContext();
            List list = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)ProxyJDBCExecutorCallbackFactory.newInstance(this.type, protocolType, database.getResourceMetaData(), context.getSqlStatement(), this.databaseConnector, isReturnGeneratedKeys, isExceptionThrown, true), (JDBCExecutorCallback)ProxyJDBCExecutorCallbackFactory.newInstance(this.type, protocolType, database.getResourceMetaData(), context.getSqlStatement(), this.databaseConnector, isReturnGeneratedKeys, isExceptionThrown, false));
            return list;
        }
        finally {
            this.processEngine.completeSQLExecution(executionGroupContext.getReportContext().getProcessId());
        }
    }

    @Generated
    public ProxyJDBCExecutor(String type, ConnectionSession connectionSession, DatabaseConnector databaseConnector, JDBCExecutor jdbcExecutor) {
        this.type = type;
        this.connectionSession = connectionSession;
        this.databaseConnector = databaseConnector;
        this.jdbcExecutor = jdbcExecutor;
    }
}

