/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgreSQLTextArrayBinaryProtocolValue
implements PostgreSQLBinaryProtocolValue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLTextArrayBinaryProtocolValue.class);
    private static final int ARRAY_HEADER_LENGTH = 20;

    @Override
    public int getColumnLength(Object value) {
        throw new UnsupportedSQLOperationException("PostgreSQLTextArrayBinaryProtocolValue.getColumnLength()");
    }

    @Override
    public Object read(PostgreSQLPacketPayload payload, int parameterValueLength) {
        if (20 == parameterValueLength) {
            return this.getTextArray(Collections.emptyList());
        }
        byte[] header = new byte[20];
        payload.getByteBuf().readBytes(header);
        byte[] dataBytes = new byte[parameterValueLength - 20];
        payload.getByteBuf().readBytes(dataBytes);
        return this.getTextArray(this.extractArrayElements(dataBytes));
    }

    private Object getTextArray(Collection<String> elements) {
        try {
            PGobject result = new PGobject();
            result.setType("text[]");
            result.setValue(this.getArrayString(elements));
            return result;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    private String getArrayString(Collection<String> elements) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator<String> iterator = elements.iterator();
        while (iterator.hasNext()) {
            sb.append("\"").append(iterator.next()).append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private Collection<String> extractArrayElements(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        LinkedList<String> result = new LinkedList<String>();
        while (buffer.remaining() > 0) {
            int length = buffer.getInt();
            if (buffer.remaining() < length) {
                log.warn("cannot read the complete data packet, remaining: {}, expected: {}", (Object)buffer.remaining(), (Object)length);
                break;
            }
            byte[] packetData = new byte[length];
            buffer.get(packetData);
            result.add(new String(packetData, StandardCharsets.UTF_8));
        }
        return result;
    }

    @Override
    public void write(PostgreSQLPacketPayload payload, Object value) {
        throw new UnsupportedSQLOperationException("PostgreSQLTextArrayBinaryProtocolValue.write()");
    }
}

