/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.table;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;

public final class CreateTableStatementSchemaRefresher
implements MetaDataRefresher<CreateTableStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, CreateTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String tableName = TableRefreshUtils.getTableName(databaseType, sqlStatement.getTable().getTableName().getIdentifier());
        RuleMetaData ruleMetaData = new RuleMetaData(new LinkedList(database.getRuleMetaData().getRules()));
        boolean isSingleTable = TableRefreshUtils.isSingleTable(tableName, database);
        if (isSingleTable) {
            ruleMetaData.getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.put((String)logicDataSourceNames.iterator().next(), schemaName, tableName));
        }
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getResourceMetaData().getStorageUnits(), ruleMetaData.getRules(), props, schemaName);
        Map schemas = GenericSchemaBuilder.build(Collections.singletonList(tableName), (DatabaseType)database.getProtocolType(), (GenericSchemaBuilderMaterial)material);
        Optional<ShardingSphereTable> actualTableMetaData = Optional.ofNullable((ShardingSphereSchema)schemas.get(schemaName)).map(optional -> optional.getTable(tableName));
        Preconditions.checkState((boolean)actualTableMetaData.isPresent(), (String)"Load actual table metadata '%s' failed.", (Object)tableName);
        metaDataManagerPersistService.createTable(database.getName(), schemaName, actualTableMetaData.get(), logicDataSourceNames.isEmpty() ? null : logicDataSourceNames.iterator().next());
        if (isSingleTable && TableRefreshUtils.isRuleRefreshRequired(ruleMetaData, schemaName, tableName)) {
            metaDataManagerPersistService.alterSingleRuleConfiguration(database.getName(), ruleMetaData.getConfigurations());
        }
    }

    @Override
    public Class<CreateTableStatement> getType() {
        return CreateTableStatement.class;
    }
}

