/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.node.path.rule.RuleNodePath;
import org.apache.shardingsphere.mode.node.path.rule.item.NamedRuleItemNodePath;
import org.apache.shardingsphere.mode.node.path.rule.item.UniqueRuleItemNodePath;
import org.apache.shardingsphere.mode.node.spi.RuleNodePathProvider;
import org.apache.shardingsphere.mode.spi.rule.item.RuleChangedItem;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterUniqueRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropUniqueRuleItem;

public final class RuleItemChangedBuilder {
    public Optional<RuleChangedItem> build(String databaseName, String activeVersionKey, String activeVersion, DataChangedEvent.Type changedType) {
        for (RuleNodePathProvider each : ShardingSphereServiceLoader.getServiceInstances(RuleNodePathProvider.class)) {
            Optional<RuleChangedItem> result = this.build(each.getRuleNodePath(), databaseName, activeVersionKey, activeVersion, changedType);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private Optional<RuleChangedItem> build(RuleNodePath ruleNodePath, String databaseName, String activeVersionKey, String activeVersion, DataChangedEvent.Type changedType) {
        if (!ruleNodePath.getRoot().isValidatedPath(activeVersionKey) || DataChangedEvent.Type.DELETED != changedType && Strings.isNullOrEmpty((String)activeVersion)) {
            return Optional.empty();
        }
        for (Map.Entry entry : ruleNodePath.getNamedItems().entrySet()) {
            Optional itemName = DataChangedEvent.Type.ADDED == changedType || DataChangedEvent.Type.UPDATED == changedType ? ((NamedRuleItemNodePath)entry.getValue()).getNameByActiveVersion(activeVersionKey) : ((NamedRuleItemNodePath)entry.getValue()).getNameByItemPath(activeVersionKey);
            if (!itemName.isPresent()) continue;
            return Optional.of(this.create(databaseName, (String)itemName.get(), activeVersionKey, activeVersion, changedType, ruleNodePath.getRoot().getRuleType() + "." + (String)entry.getKey()));
        }
        for (Map.Entry entry : ruleNodePath.getUniqueItems().entrySet()) {
            if (!((UniqueRuleItemNodePath)entry.getValue()).isActiveVersionPath(activeVersionKey)) continue;
            return Optional.of(this.create(databaseName, activeVersionKey, activeVersion, changedType, ruleNodePath.getRoot().getRuleType() + "." + (String)entry.getKey()));
        }
        return Optional.empty();
    }

    private RuleChangedItem create(String databaseName, String itemName, String activeVersionKey, String activeVersion, DataChangedEvent.Type changedType, String type) {
        return DataChangedEvent.Type.ADDED == changedType || DataChangedEvent.Type.UPDATED == changedType ? new AlterNamedRuleItem(databaseName, itemName, activeVersionKey, activeVersion, type) : new DropNamedRuleItem(databaseName, itemName, type);
    }

    private RuleChangedItem create(String databaseName, String activeVersionKey, String activeVersion, DataChangedEvent.Type changedType, String type) {
        return DataChangedEvent.Type.ADDED == changedType || DataChangedEvent.Type.UPDATED == changedType ? new AlterUniqueRuleItem(databaseName, activeVersionKey, activeVersion, type) : new DropUniqueRuleItem(databaseName, type);
    }
}

