/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.route;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.lifecycle.DecorateSQLRouter;
import org.apache.shardingsphere.infra.route.lifecycle.EntranceSQLRouter;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.single.route.engine.SingleRouteEngine;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;

public final class SingleSQLRouter
implements EntranceSQLRouter<SingleRule>,
DecorateSQLRouter<SingleRule> {
    public RouteContext createRouteContext(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, SingleRule rule, Collection<String> tableNames, ConfigurationProperties props) {
        if (1 == database.getResourceMetaData().getStorageUnits().size()) {
            return this.createSingleDataSourceRouteContext(rule, database, queryContext);
        }
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        RouteContext routeContext = new RouteContext();
        Collection<QualifiedTable> singleTables = this.getSingleTables(database, rule, sqlStatementContext);
        if (singleTables.isEmpty()) {
            return routeContext;
        }
        return new SingleRouteEngine(singleTables, sqlStatementContext.getSqlStatement(), queryContext.getHintValueContext()).route(routeContext, rule);
    }

    public void decorateRouteContext(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, SingleRule rule, Collection<String> tableNames, ConfigurationProperties props) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        Collection<QualifiedTable> singleTables = this.getSingleTables(database, rule, sqlStatementContext);
        if (singleTables.isEmpty()) {
            return;
        }
        new SingleRouteEngine(singleTables, sqlStatementContext.getSqlStatement(), queryContext.getHintValueContext()).route(routeContext, rule);
    }

    private RouteContext createSingleDataSourceRouteContext(SingleRule rule, ShardingSphereDatabase database, QueryContext queryContext) {
        String logicDataSource = rule.getDataSourceNames().iterator().next();
        String actualDataSource = (String)database.getResourceMetaData().getStorageUnits().keySet().iterator().next();
        RouteContext result = new RouteContext();
        List<String> tableNames = queryContext.getSqlStatementContext() instanceof TableAvailable ? ((TableAvailable)queryContext.getSqlStatementContext()).getTablesContext().getTableNames() : Collections.emptyList();
        result.getRouteUnits().add(new RouteUnit(new RouteMapper(logicDataSource, actualDataSource), this.createTableMappers(tableNames)));
        return result;
    }

    private Collection<RouteMapper> createTableMappers(Collection<String> tableNames) {
        LinkedList<RouteMapper> result = new LinkedList<RouteMapper>();
        for (String each : tableNames) {
            result.add(new RouteMapper(each, each));
        }
        return result;
    }

    private Collection<QualifiedTable> getSingleTables(ShardingSphereDatabase database, SingleRule rule, SQLStatementContext sqlStatementContext) {
        Collection<QualifiedTable> qualifiedTables = rule.getQualifiedTables(sqlStatementContext, database);
        Collection<String> distributedTableNames = this.getDistributedTableNames(database);
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        for (QualifiedTable each : qualifiedTables) {
            if (distributedTableNames.contains(each.getTableName())) continue;
            result.add(each);
        }
        return sqlStatementContext.getSqlStatement() instanceof CreateTableStatement ? result : rule.getSingleTables(result);
    }

    private Collection<String> getDistributedTableNames(ShardingSphereDatabase database) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        for (TableMapperRuleAttribute each : database.getRuleMetaData().getAttributes(TableMapperRuleAttribute.class)) {
            result.addAll(each.getDistributedTableNames());
        }
        return result;
    }

    public SQLRouter.Type getType() {
        return SQLRouter.Type.DATA_NODE;
    }

    public int getOrder() {
        return 5;
    }

    public Class<SingleRule> getTypeClass() {
        return SingleRule.class;
    }
}

