/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.node.path.rule.RuleNodePath;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;

public final class NamedRuleItemChangedHandler {
    private final ContextManager contextManager;

    public void handle(RuleNodePath ruleNodePath, String databaseName, String itemName, String path, DataChangedEvent event) throws SQLException {
        String type = ruleNodePath.getRoot().getRuleType() + "." + path;
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            this.contextManager.getMetaDataContextManager().getRuleItemManager().alterRuleItem((AlterRuleItem)new AlterNamedRuleItem(databaseName, itemName, event.getKey(), event.getValue(), type));
        } else if (DataChangedEvent.Type.DELETED == event.getType()) {
            this.contextManager.getMetaDataContextManager().getRuleItemManager().dropRuleItem((DropRuleItem)new DropNamedRuleItem(databaseName, itemName, type));
        }
    }

    @Generated
    public NamedRuleItemChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

