/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.timeservice.core.rule.TimestampServiceRule;

public final class ConditionValueInOperatorGenerator
implements ConditionValueGenerator<InExpression> {
    @Override
    public Optional<ShardingConditionValue> generate(InExpression predicate, Column column, List<Object> params, TimestampServiceRule timestampServiceRule) {
        if (predicate.isNot()) {
            return Optional.empty();
        }
        Collection expressionSegments = predicate.getExpressionList();
        ArrayList<Integer> parameterMarkerIndexes = new ArrayList<Integer>(expressionSegments.size());
        LinkedList shardingConditionValues = new LinkedList();
        for (ExpressionSegment each : expressionSegments) {
            ConditionValue conditionValue = new ConditionValue(each, params);
            Optional<Comparable<?>> value = conditionValue.getValue();
            if (conditionValue.isNull()) {
                shardingConditionValues.add(null);
                conditionValue.getParameterMarkerIndex().ifPresent(parameterMarkerIndexes::add);
                continue;
            }
            if (value.isPresent()) {
                shardingConditionValues.add(value.get());
                conditionValue.getParameterMarkerIndex().ifPresent(parameterMarkerIndexes::add);
                continue;
            }
            if (!ExpressionConditionUtils.isNowExpression(each)) continue;
            shardingConditionValues.add(timestampServiceRule.getTimestamp());
        }
        return shardingConditionValues.isEmpty() ? Optional.empty() : Optional.of(new ListShardingConditionValue(column.getName(), column.getTableName(), shardingConditionValues, parameterMarkerIndexes));
    }
}

