/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.PrimitiveLongList;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.AutoValue_ImmutableHistogramPointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.HistogramPointDataValidations;

@Immutable
@AutoValue
public abstract class ImmutableHistogramPointData
implements HistogramPointData {
    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes, double sum, boolean hasMin, double min, boolean hasMax, double max, List<Double> boundaries, List<Long> counts) {
        return ImmutableHistogramPointData.create(startEpochNanos, epochNanos, attributes, sum, hasMin, min, hasMax, max, boundaries, counts, Collections.emptyList());
    }

    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes, double sum, boolean hasMin, double min, boolean hasMax, double max, List<Double> boundaries, List<Long> counts, List<DoubleExemplarData> exemplars) {
        if (counts.size() != boundaries.size() + 1) {
            throw new IllegalArgumentException("invalid counts: size should be " + (boundaries.size() + 1) + " instead of " + counts.size());
        }
        HistogramPointDataValidations.validateIsStrictlyIncreasing(boundaries);
        HistogramPointDataValidations.validateFiniteBoundaries(boundaries);
        long totalCount = 0L;
        for (long c : PrimitiveLongList.toArray(counts)) {
            totalCount += c;
        }
        return new AutoValue_ImmutableHistogramPointData(startEpochNanos, epochNanos, attributes, sum, totalCount, hasMin, min, hasMax, max, Collections.unmodifiableList(new ArrayList<Double>(boundaries)), Collections.unmodifiableList(new ArrayList<Long>(counts)), exemplars);
    }

    ImmutableHistogramPointData() {
    }
}

