/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.context;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.ConsistencyCheckJobItemProgressContext;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineProcessContext;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.progress.ConsistencyCheckJobItemProgress;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.config.ConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.context.ConsistencyCheckProcessContext;

public final class ConsistencyCheckJobItemContext
implements PipelineJobItemContext {
    private final String jobId;
    private final int shardingItem;
    private String dataSourceName;
    private volatile boolean stopping;
    private volatile JobStatus status;
    private final ConsistencyCheckJobConfiguration jobConfig;
    private final ConsistencyCheckJobItemProgressContext progressContext;
    private final ConsistencyCheckProcessContext processContext;

    public ConsistencyCheckJobItemContext(ConsistencyCheckJobConfiguration jobConfig, int shardingItem, JobStatus status, ConsistencyCheckJobItemProgress jobItemProgress) {
        this.jobConfig = jobConfig;
        this.jobId = jobConfig.getJobId();
        this.shardingItem = shardingItem;
        this.status = status;
        this.progressContext = new ConsistencyCheckJobItemProgressContext(this.jobId, shardingItem, jobConfig.getSourceDatabaseType().getType());
        if (null != jobItemProgress) {
            this.progressContext.getCheckedRecordsCount().set(Optional.ofNullable(jobItemProgress.getCheckedRecordsCount()).orElse(0L));
            Optional.ofNullable(jobItemProgress.getSourceTableCheckPositions()).ifPresent(this.progressContext.getSourceTableCheckPositions()::putAll);
            Optional.ofNullable(jobItemProgress.getTargetTableCheckPositions()).ifPresent(this.progressContext.getTargetTableCheckPositions()::putAll);
        }
        this.processContext = new ConsistencyCheckProcessContext(this.jobId);
    }

    public PipelineProcessContext getJobProcessContext() {
        return this.processContext;
    }

    public ConsistencyCheckJobItemProgress toProgress() {
        ConsistencyCheckJobItemProgress result = new ConsistencyCheckJobItemProgress(this.progressContext);
        result.setStatus(this.status);
        return result;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public boolean isStopping() {
        return this.stopping;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public ConsistencyCheckJobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public ConsistencyCheckJobItemProgressContext getProgressContext() {
        return this.progressContext;
    }

    @Generated
    public ConsistencyCheckProcessContext getProcessContext() {
        return this.processContext;
    }

    @Generated
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Generated
    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }
}

