/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.from.type;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.database.opengauss.type.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.postgresql.type.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SimpleTableSegmentBinder {
    private static final Collection<String> SYSTEM_CATALOG_TABLES = new CaseInsensitiveSet(4, 1.0f);
    private static final String PG_CATALOG = "pg_catalog";

    public static SimpleTableSegment bind(SimpleTableSegment segment, SQLStatementBinderContext binderContext, Map<String, TableSegmentBinderContext> tableBinderContexts) {
        SimpleTableSegmentBinder.fillPivotColumnNamesInBinderContext(segment, binderContext);
        IdentifierValue databaseName = SimpleTableSegmentBinder.getDatabaseName(segment, binderContext);
        ShardingSpherePreconditions.checkNotNull((Object)databaseName.getValue(), NoDatabaseSelectedException::new);
        IdentifierValue schemaName = SimpleTableSegmentBinder.getSchemaName(segment, binderContext);
        IdentifierValue tableName = segment.getTableName().getIdentifier();
        SimpleTableSegmentBinder.checkTableExists(binderContext, databaseName.getValue(), schemaName.getValue(), tableName.getValue());
        ShardingSphereSchema schema = binderContext.getMetaData().getDatabase(databaseName.getValue()).getSchema(schemaName.getValue());
        tableBinderContexts.putIfAbsent(segment.getAliasName().orElseGet(() -> ((IdentifierValue)tableName).getValue()).toLowerCase(), SimpleTableSegmentBinder.createSimpleTableBinderContext(segment, schema, databaseName, schemaName, binderContext));
        TableNameSegment tableNameSegment = new TableNameSegment(segment.getTableName().getStartIndex(), segment.getTableName().getStopIndex(), tableName);
        SimpleTableSegment result = new SimpleTableSegment(tableNameSegment);
        segment.getOwner().ifPresent(arg_0 -> ((SimpleTableSegment)result).setOwner(arg_0));
        segment.getAliasSegment().ifPresent(arg_0 -> ((SimpleTableSegment)result).setAlias(arg_0));
        return result;
    }

    private static void fillPivotColumnNamesInBinderContext(SimpleTableSegment segment, SQLStatementBinderContext binderContext) {
        segment.getPivot().ifPresent(optional -> optional.getPivotColumns().forEach(each -> binderContext.getPivotColumnNames().add(each.getIdentifier().getValue().toLowerCase())));
    }

    private static IdentifierValue getDatabaseName(SimpleTableSegment segment, SQLStatementBinderContext binderContext) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(binderContext.getDatabaseType()).getDialectDatabaseMetaData();
        Optional<String> owner = dialectDatabaseMetaData.getDefaultSchema().isPresent() ? segment.getOwner().flatMap(OwnerSegment::getOwner) : segment.getOwner();
        return new IdentifierValue(owner.map(optional -> optional.getIdentifier().getValue()).orElse(binderContext.getCurrentDatabaseName()));
    }

    private static IdentifierValue getSchemaName(SimpleTableSegment segment, SQLStatementBinderContext binderContext) {
        if (segment.getOwner().isPresent()) {
            return ((OwnerSegment)segment.getOwner().get()).getIdentifier();
        }
        DatabaseType databaseType = binderContext.getDatabaseType();
        if ((databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) && SYSTEM_CATALOG_TABLES.contains(segment.getTableName().getIdentifier().getValue())) {
            return new IdentifierValue(PG_CATALOG);
        }
        return new IdentifierValue(new DatabaseTypeRegistry(databaseType).getDefaultSchemaName(binderContext.getCurrentDatabaseName()));
    }

    private static void checkTableExists(SQLStatementBinderContext binderContext, String databaseName, String schemaName, String tableName) {
        if ("dual".equalsIgnoreCase(tableName)) {
            return;
        }
        if (SystemSchemaManager.isSystemTable((String)schemaName, (String)tableName)) {
            return;
        }
        if (binderContext.getExternalTableBinderContexts().containsKey(tableName)) {
            return;
        }
        ShardingSpherePreconditions.checkState((binderContext.getMetaData().containsDatabase(databaseName) && binderContext.getMetaData().getDatabase(databaseName).containsSchema(schemaName) && binderContext.getMetaData().getDatabase(databaseName).getSchema(schemaName).containsTable(tableName) ? 1 : 0) != 0, () -> new TableNotFoundException(tableName));
    }

    private static SimpleTableSegmentBinderContext createSimpleTableBinderContext(SimpleTableSegment segment, ShardingSphereSchema schema, IdentifierValue databaseName, IdentifierValue schemaName, SQLStatementBinderContext binderContext) {
        IdentifierValue tableName = segment.getTableName().getIdentifier();
        if (binderContext.getMetaData().getDatabase(databaseName.getValue()).getSchema(schemaName.getValue()).containsTable(tableName.getValue())) {
            return SimpleTableSegmentBinder.createSimpleTableSegmentBinderContextWithMetaData(segment, schema, databaseName, schemaName, binderContext, tableName);
        }
        return new SimpleTableSegmentBinderContext(Collections.emptyList());
    }

    private static SimpleTableSegmentBinderContext createSimpleTableSegmentBinderContextWithMetaData(SimpleTableSegment segment, ShardingSphereSchema schema, IdentifierValue databaseName, IdentifierValue schemaName, SQLStatementBinderContext binderContext, IdentifierValue tableName) {
        LinkedList<ProjectionSegment> projectionSegments = new LinkedList<ProjectionSegment>();
        QuoteCharacter quoteCharacter = new DatabaseTypeRegistry(binderContext.getDatabaseType()).getDialectDatabaseMetaData().getQuoteCharacter();
        for (ShardingSphereColumn each : schema.getTable(tableName.getValue()).getColumnValues()) {
            ColumnProjectionSegment columnProjectionSegment = new ColumnProjectionSegment(SimpleTableSegmentBinder.createColumnSegment(segment, databaseName, schemaName, each, quoteCharacter, tableName));
            columnProjectionSegment.setVisible(each.isVisible());
            projectionSegments.add((ProjectionSegment)columnProjectionSegment);
        }
        return new SimpleTableSegmentBinderContext(projectionSegments);
    }

    private static ColumnSegment createColumnSegment(SimpleTableSegment segment, IdentifierValue databaseName, IdentifierValue schemaName, ShardingSphereColumn column, QuoteCharacter quoteCharacter, IdentifierValue tableName) {
        ColumnSegment result = new ColumnSegment(0, 0, new IdentifierValue(column.getName(), quoteCharacter));
        result.setOwner(new OwnerSegment(0, 0, segment.getAlias().orElse(tableName)));
        result.setColumnBoundInfo(new ColumnSegmentBoundInfo(databaseName, schemaName, tableName, new IdentifierValue(column.getName(), quoteCharacter)));
        return result;
    }

    @Generated
    private SimpleTableSegmentBinder() {
    }

    static {
        SYSTEM_CATALOG_TABLES.add("pg_database");
        SYSTEM_CATALOG_TABLES.add("pg_tables");
        SYSTEM_CATALOG_TABLES.add("pg_roles");
        SYSTEM_CATALOG_TABLES.add("pg_settings");
    }
}

