/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.parser.core;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.SingleDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.SingleDistSQLStatementParser;
import org.apache.shardingsphere.distsql.statement.rql.rule.database.CountRuleStatement;
import org.apache.shardingsphere.single.distsql.segment.SingleTableSegment;
import org.apache.shardingsphere.single.distsql.statement.rdl.LoadSingleTableStatement;
import org.apache.shardingsphere.single.distsql.statement.rdl.SetDefaultSingleTableStorageUnitStatement;
import org.apache.shardingsphere.single.distsql.statement.rdl.UnloadSingleTableStatement;
import org.apache.shardingsphere.single.distsql.statement.rql.ShowDefaultSingleTableStorageUnitStatement;
import org.apache.shardingsphere.single.distsql.statement.rql.ShowSingleTablesStatement;
import org.apache.shardingsphere.single.distsql.statement.rql.ShowUnloadedSingleTablesStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SingleDistSQLStatementVisitor
extends SingleDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitCountSingleTable(SingleDistSQLStatementParser.CountSingleTableContext ctx) {
        return new CountRuleStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), "SINGLE");
    }

    @Override
    public ASTNode visitSetDefaultSingleTableStorageUnit(SingleDistSQLStatementParser.SetDefaultSingleTableStorageUnitContext ctx) {
        return new SetDefaultSingleTableStorageUnitStatement(null == ctx.storageUnitName() ? null : this.getIdentifierValue((ParseTree)ctx.storageUnitName()));
    }

    @Override
    public ASTNode visitShowDefaultSingleTableStorageUnit(SingleDistSQLStatementParser.ShowDefaultSingleTableStorageUnitContext ctx) {
        return new ShowDefaultSingleTableStorageUnitStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowSingleTables(SingleDistSQLStatementParser.ShowSingleTablesContext ctx) {
        return new ShowSingleTablesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), null == ctx.showLike() ? null : this.getIdentifierValue((ParseTree)ctx.showLike().likePattern()));
    }

    @Override
    public ASTNode visitLoadSingleTable(SingleDistSQLStatementParser.LoadSingleTableContext ctx) {
        Collection tables = ctx.tableDefinition().tableIdentifier().stream().map(this::getSingleTableSegment).collect(Collectors.toSet());
        return new LoadSingleTableStatement(tables);
    }

    @Override
    public ASTNode visitUnloadSingleTable(SingleDistSQLStatementParser.UnloadSingleTableContext ctx) {
        if (null != ctx.ALL() || null != ctx.ASTERISK_()) {
            return new UnloadSingleTableStatement(true, Collections.emptyList());
        }
        return new UnloadSingleTableStatement(false, (Collection)ctx.tableNames().tableName().stream().map(this::getIdentifierValue).collect(Collectors.toSet()));
    }

    private SingleTableSegment getSingleTableSegment(SingleDistSQLStatementParser.TableIdentifierContext ctx) {
        if (ctx instanceof SingleDistSQLStatementParser.AllTablesFromStorageUnitContext) {
            return new SingleTableSegment(this.getIdentifierValue((ParseTree)((SingleDistSQLStatementParser.AllTablesFromStorageUnitContext)ctx).storageUnitName()), "*");
        }
        if (ctx instanceof SingleDistSQLStatementParser.AllTablesFromSchemaContext) {
            SingleDistSQLStatementParser.AllTablesFromSchemaContext tableContext = (SingleDistSQLStatementParser.AllTablesFromSchemaContext)ctx;
            return new SingleTableSegment(this.getIdentifierValue((ParseTree)tableContext.storageUnitName()), this.getIdentifierValue((ParseTree)tableContext.schemaName()), "*");
        }
        if (ctx instanceof SingleDistSQLStatementParser.TableFromStorageUnitContext) {
            SingleDistSQLStatementParser.TableFromStorageUnitContext tableContext = (SingleDistSQLStatementParser.TableFromStorageUnitContext)ctx;
            return new SingleTableSegment(this.getIdentifierValue((ParseTree)tableContext.storageUnitName()), this.getIdentifierValue((ParseTree)tableContext.tableName()));
        }
        if (ctx instanceof SingleDistSQLStatementParser.TableFromSchemaContext) {
            SingleDistSQLStatementParser.TableFromSchemaContext tableContext = (SingleDistSQLStatementParser.TableFromSchemaContext)ctx;
            return new SingleTableSegment(this.getIdentifierValue((ParseTree)tableContext.storageUnitName()), this.getIdentifierValue((ParseTree)tableContext.schemaName()), this.getIdentifierValue((ParseTree)tableContext.tableName()));
        }
        if (ctx instanceof SingleDistSQLStatementParser.AllTablesContext) {
            return new SingleTableSegment("*", "*");
        }
        if (ctx instanceof SingleDistSQLStatementParser.AllSchamesAndTablesFromStorageUnitContext) {
            return new SingleTableSegment(this.getIdentifierValue((ParseTree)((SingleDistSQLStatementParser.AllSchamesAndTablesFromStorageUnitContext)ctx).storageUnitName()), "*", "*");
        }
        return new SingleTableSegment("*", "*", "*");
    }

    @Override
    public ASTNode visitShowUnloadedSingleTables(SingleDistSQLStatementParser.ShowUnloadedSingleTablesContext ctx) {
        return null == ctx.fromClause() ? new ShowUnloadedSingleTablesStatement(null, null, null) : this.visitShowUnloadedSingleTablesWithFromClause(ctx.fromClause());
    }

    private ASTNode visitShowUnloadedSingleTablesWithFromClause(SingleDistSQLStatementParser.FromClauseContext ctx) {
        return new ShowUnloadedSingleTablesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), null == ctx.storageUnitName() ? null : this.getIdentifierValue((ParseTree)ctx.storageUnitName()), null == ctx.schemaName() ? null : this.getIdentifierValue((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitDatabaseName(SingleDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }
}

