/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowComputeNodeInfoStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.proxy.ProxyInstanceMetaData;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowComputeNodeInfoExecutor
implements DistSQLQueryExecutor<ShowComputeNodeInfoStatement> {
    public Collection<String> getColumnNames(ShowComputeNodeInfoStatement sqlStatement) {
        return Arrays.asList("instance_id", "host", "port", "status", "mode_type", "worker_id", "labels", "version");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowComputeNodeInfoStatement sqlStatement, ContextManager contextManager) {
        ComputeNodeInstance instance = contextManager.getComputeNodeInstanceContext().getInstance();
        InstanceMetaData instanceMetaData = instance.getMetaData();
        String modeType = contextManager.getComputeNodeInstanceContext().getModeConfiguration().getType();
        return Collections.singletonList(new LocalDataQueryResultRow(new Object[]{instanceMetaData.getId(), instanceMetaData.getIp(), instanceMetaData instanceof ProxyInstanceMetaData ? ((ProxyInstanceMetaData)instanceMetaData).getPort() : -1, instance.getState().getCurrentState(), modeType, instance.getWorkerId(), String.join((CharSequence)",", instance.getLabels()), instanceMetaData.getVersion()}));
    }

    public Class<ShowComputeNodeInfoStatement> getType() {
        return ShowComputeNodeInfoStatement.class;
    }
}

