/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.codec.binary.Base64;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.ral.queryable.export.ExportMetaDataStatement;
import org.apache.shardingsphere.globalclock.provider.GlobalClockProvider;
import org.apache.shardingsphere.globalclock.rule.GlobalClockRule;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.decorator.RuleConfigurationPersistDecorateEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedClusterInfo;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedMetaData;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedSnapshotInfo;
import org.apache.shardingsphere.proxy.backend.util.ExportUtils;

public final class ExportMetaDataExecutor
implements DistSQLQueryExecutor<ExportMetaDataStatement> {
    public Collection<String> getColumnNames(ExportMetaDataStatement sqlStatement) {
        return Arrays.asList("id", "create_time", "cluster_info");
    }

    public Collection<LocalDataQueryResultRow> getRows(ExportMetaDataStatement sqlStatement, ContextManager contextManager) {
        String exportedData = this.generateExportData(contextManager.getMetaDataContexts().getMetaData());
        if (sqlStatement.getFilePath().isPresent()) {
            String filePath = (String)sqlStatement.getFilePath().get();
            ExportUtils.exportToFile(filePath, exportedData);
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId(), LocalDateTime.now(), String.format("Successfully exported to\uff1a'%s'", filePath)}));
        }
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId(), LocalDateTime.now(), Base64.encodeBase64String((byte[])exportedData.getBytes())}));
    }

    private String generateExportData(ShardingSphereMetaData metaData) {
        ProxyContext proxyContext = ProxyContext.getInstance();
        ExportedMetaData exportedMetaData = new ExportedMetaData();
        exportedMetaData.setDatabases(this.getDatabases(proxyContext));
        exportedMetaData.setProps(this.generatePropsData(metaData.getProps().getProps()));
        RuleConfigurationPersistDecorateEngine ruleConfigPersistDecorateEngine = new RuleConfigurationPersistDecorateEngine(ProxyContext.getInstance().getContextManager().getComputeNodeInstanceContext());
        Collection ruleConfigs = ruleConfigPersistDecorateEngine.decorate(metaData.getGlobalRuleMetaData().getConfigurations());
        exportedMetaData.setRules(this.generateRulesData(ruleConfigs));
        ExportedClusterInfo exportedClusterInfo = new ExportedClusterInfo();
        exportedClusterInfo.setMetaData(exportedMetaData);
        this.generateSnapshotInfo(metaData, exportedClusterInfo);
        return JsonUtils.toJsonString((Object)exportedClusterInfo);
    }

    private Map<String, String> getDatabases(ProxyContext proxyContext) {
        Collection<String> databaseNames = proxyContext.getAllDatabaseNames();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(databaseNames.size(), 1.0f);
        databaseNames.forEach(each -> {
            ShardingSphereDatabase database = proxyContext.getContextManager().getDatabase(each);
            if (database.getResourceMetaData().getAllInstanceDataSourceNames().isEmpty()) {
                return;
            }
            result.put((String)each, ExportUtils.generateExportDatabaseData(database));
        });
        return result;
    }

    private String generatePropsData(Properties props) {
        if (props.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("props:").append(System.lineSeparator());
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (null != value && !"".equals(value)) {
                result.append("  ").append(key).append(": ").append(value).append(System.lineSeparator());
            }
        }));
        return result.toString();
    }

    private String generateRulesData(Collection<RuleConfiguration> rules) {
        if (rules.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("rules:").append(System.lineSeparator());
        for (Map.Entry entry : OrderedSPILoader.getServices(YamlRuleConfigurationSwapper.class, rules).entrySet()) {
            result.append(YamlEngine.marshal(Collections.singletonList(((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey()))));
        }
        return result.toString();
    }

    private void generateSnapshotInfo(ShardingSphereMetaData metaData, ExportedClusterInfo exportedClusterInfo) {
        GlobalClockRule globalClockRule = (GlobalClockRule)metaData.getGlobalRuleMetaData().getSingleRule(GlobalClockRule.class);
        if (globalClockRule.getConfiguration().isEnabled()) {
            ExportedSnapshotInfo snapshotInfo = new ExportedSnapshotInfo();
            snapshotInfo.setCsn(String.valueOf(globalClockRule.getGlobalClockProvider().map(GlobalClockProvider::getCurrentTimestamp).orElse(0L)));
            snapshotInfo.setCreateTime(LocalDateTime.now());
            exportedClusterInfo.setSnapshotInfo(snapshotInfo);
        }
    }

    public Class<ExportMetaDataStatement> getType() {
        return ExportMetaDataStatement.class;
    }
}

