/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.QueryableRALStatement;
import org.apache.shardingsphere.distsql.statement.rql.RQLStatement;
import org.apache.shardingsphere.distsql.statement.rul.RULStatement;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.executor.checker.SQLExecutionChecker;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.state.cluster.ClusterState;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.distsql.DistSQLStatementContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.database.DatabaseOperateBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.skip.SkipBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.transaction.TransactionBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.transaction.TransactionalErrorAllowedSQLStatementHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.state.ProxyClusterState;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.EmptyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.FlushStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLShowCreateUserStatement;
import org.apache.shardingsphere.transaction.util.AutoCommitUtils;

public final class ProxyBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(DatabaseType databaseType, String sql, SQLStatement sqlStatement, ConnectionSession connectionSession, HintValueContext hintValueContext) throws SQLException {
        if (sqlStatement instanceof EmptyStatement) {
            return new SkipBackendHandler(sqlStatement);
        }
        DistSQLStatementContext sqlStatementContext = sqlStatement instanceof DistSQLStatement ? new DistSQLStatementContext((DistSQLStatement)sqlStatement) : new SQLBindEngine(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(), connectionSession.getCurrentDatabaseName(), hintValueContext).bind(sqlStatement, Collections.emptyList());
        QueryContext queryContext = new QueryContext((SQLStatementContext)sqlStatementContext, sql, Collections.emptyList(), hintValueContext, connectionSession.getConnectionContext(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData());
        connectionSession.setQueryContext(queryContext);
        return ProxyBackendHandlerFactory.newInstance(databaseType, queryContext, connectionSession, false);
    }

    public static ProxyBackendHandler newInstance(DatabaseType databaseType, QueryContext queryContext, ConnectionSession connectionSession, boolean preferPreparedStatement) throws SQLException {
        String databaseName;
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        ProxyBackendHandlerFactory.allowExecutingWhenTransactionalError(databaseType, connectionSession, sqlStatement);
        ProxyBackendHandlerFactory.checkUnsupportedSQLStatement(sqlStatement);
        ProxyBackendHandlerFactory.checkClusterState(sqlStatement);
        if (sqlStatement instanceof EmptyStatement) {
            return new SkipBackendHandler(sqlStatement);
        }
        if (sqlStatement instanceof DistSQLStatement) {
            ProxyBackendHandlerFactory.checkUnsupportedDistSQLStatementInTransaction(sqlStatement, connectionSession);
            return DistSQLBackendHandlerFactory.newInstance((DistSQLStatement)sqlStatement, connectionSession);
        }
        String sql = queryContext.getSql();
        ProxyBackendHandlerFactory.handleAutoCommit(sqlStatement, connectionSession);
        if (sqlStatement instanceof TCLStatement) {
            return TransactionBackendHandlerFactory.newInstance(sqlStatementContext, sql, connectionSession);
        }
        Optional<ProxyBackendHandler> backendHandler = DatabaseAdminBackendHandlerFactory.newInstance(databaseType, sqlStatementContext, connectionSession, sql, queryContext.getParameters());
        if (backendHandler.isPresent()) {
            return backendHandler.get();
        }
        Optional<ProxyBackendHandler> databaseOperateHandler = ProxyBackendHandlerFactory.findDatabaseOperateBackendHandler(sqlStatement, connectionSession);
        if (databaseOperateHandler.isPresent()) {
            return databaseOperateHandler.get();
        }
        String string = databaseName = sqlStatementContext instanceof TableAvailable && ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().isPresent() ? (String)((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().get() : connectionSession.getUsedDatabaseName();
        if (null == databaseName) {
            return DatabaseBackendHandlerFactory.newInstance(queryContext, connectionSession, preferPreparedStatement);
        }
        Grantee grantee = connectionSession.getConnectionContext().getGrantee();
        ShardingSphereMetaData metaData = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        for (SQLExecutionChecker each : ShardingSphereServiceLoader.getServiceInstances(SQLExecutionChecker.class)) {
            each.check(metaData, grantee, queryContext, database);
        }
        return DatabaseAdminBackendHandlerFactory.newInstance(databaseType, sqlStatementContext, connectionSession).orElseGet(() -> DatabaseBackendHandlerFactory.newInstance(queryContext, connectionSession, preferPreparedStatement));
    }

    private static void allowExecutingWhenTransactionalError(DatabaseType databaseType, ConnectionSession connectionSession, SQLStatement sqlStatement) throws SQLException {
        if (!connectionSession.getConnectionContext().getTransactionContext().isExceptionOccur()) {
            return;
        }
        Optional allowedSQLStatementHandler = DatabaseTypedSPILoader.findService(TransactionalErrorAllowedSQLStatementHandler.class, (DatabaseType)databaseType);
        if (allowedSQLStatementHandler.isPresent()) {
            ((TransactionalErrorAllowedSQLStatementHandler)allowedSQLStatementHandler.get()).judgeContinueToExecute(sqlStatement);
        }
    }

    private static void checkUnsupportedDistSQLStatementInTransaction(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        ShardingSpherePreconditions.checkState((!connectionSession.getTransactionStatus().isInTransaction() || ProxyBackendHandlerFactory.isSupportedDistSQLStatementInTransaction(sqlStatement) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Non-query DistSQL is not supported within a transaction"));
    }

    private static boolean isSupportedDistSQLStatementInTransaction(SQLStatement sqlStatement) {
        return sqlStatement instanceof RQLStatement || sqlStatement instanceof QueryableRALStatement || sqlStatement instanceof RULStatement;
    }

    private static void handleAutoCommit(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (AutoCommitUtils.needOpenTransaction((SQLStatement)sqlStatement)) {
            connectionSession.getDatabaseConnectionManager().handleAutoCommit();
        }
    }

    private static Optional<ProxyBackendHandler> findDatabaseOperateBackendHandler(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (sqlStatement instanceof CreateDatabaseStatement || sqlStatement instanceof DropDatabaseStatement) {
            return Optional.of(DatabaseOperateBackendHandlerFactory.newInstance(sqlStatement, connectionSession));
        }
        return Optional.empty();
    }

    private static void checkUnsupportedSQLStatement(SQLStatement sqlStatement) {
        if (sqlStatement instanceof DCLStatement || sqlStatement instanceof FlushStatement || sqlStatement instanceof MySQLShowCreateUserStatement || sqlStatement instanceof RenameTableStatement) {
            throw new UnsupportedSQLOperationException(String.format("unsupported SQL statement `%s`", sqlStatement.getClass().getSimpleName()));
        }
    }

    private static void checkClusterState(SQLStatement sqlStatement) {
        ClusterState clusterCurrentState = ProxyContext.getInstance().getContextManager().getStateContext().getClusterState();
        if (ClusterState.OK != clusterCurrentState) {
            ((ProxyClusterState)TypedSPILoader.getService(ProxyClusterState.class, (Object)clusterCurrentState.name())).check(sqlStatement);
        }
    }

    @Generated
    private ProxyBackendHandlerFactory() {
    }
}

