/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper.listener;

import java.util.Properties;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.mode.persist.service.ComputeNodePersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionConnectionReconnectListener
implements ConnectionStateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionConnectionReconnectListener.class);
    private static final long RECONNECT_INTERVAL_SECONDS = 5L;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final ComputeNodePersistService computeNodePersistService;

    public SessionConnectionReconnectListener(ComputeNodeInstanceContext computeNodeInstanceContext, ClusterPersistRepository repository) {
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.computeNodePersistService = new ComputeNodePersistService((PersistRepository)repository);
    }

    public void stateChanged(CuratorFramework client, ConnectionState connectionState) {
        boolean isReconnectFailed;
        if (ConnectionState.LOST != connectionState) {
            return;
        }
        while (isReconnectFailed = !this.reconnect(client)) {
        }
        log.info("Instance reconnect success, instance ID: {}", (Object)this.computeNodeInstanceContext.getInstance().getMetaData().getId());
    }

    private boolean reconnect(CuratorFramework client) {
        try {
            if (client.getZookeeperClient().blockUntilConnectedOrTimedOut()) {
                if (this.isNeedGenerateWorkerId()) {
                    this.computeNodeInstanceContext.generateWorkerId(new Properties());
                }
                this.computeNodePersistService.registerOnline(this.computeNodeInstanceContext.getInstance());
                return true;
            }
            this.sleepInterval();
            return false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    private boolean isNeedGenerateWorkerId() {
        return -1 != this.computeNodeInstanceContext.getInstance().getWorkerId();
    }

    private void sleepInterval() {
        Thread.sleep(5000L);
    }
}

