/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.rql.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.rql.resource.ShowStorageUnitsStatement;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.CatalogSwitchableDataSource;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.util.regex.RegexUtils;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowStorageUnitExecutor
implements DistSQLQueryExecutor<ShowStorageUnitsStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    @Override
    public Collection<String> getColumnNames(ShowStorageUnitsStatement sqlStatement) {
        return Arrays.asList("name", "type", "host", "port", "db", "connection_timeout_milliseconds", "idle_timeout_milliseconds", "max_lifetime_milliseconds", "max_pool_size", "min_pool_size", "read_only", "other_attributes");
    }

    @Override
    public Collection<LocalDataQueryResultRow> getRows(ShowStorageUnitsStatement sqlStatement, ContextManager contextManager) {
        return this.getStorageUnits(sqlStatement).entrySet().stream().map(entry -> this.getRow((String)entry.getKey(), (StorageUnit)entry.getValue())).collect(Collectors.toList());
    }

    private LocalDataQueryResultRow getRow(String name, StorageUnit storageUnit) {
        ConnectionProperties connectionProps = storageUnit.getConnectionProperties();
        DataSourcePoolProperties dataSourcePoolProps = this.getDataSourcePoolProperties(storageUnit);
        Map poolProps = dataSourcePoolProps.getPoolPropertySynonyms().getStandardProperties();
        Map<String, Object> customProps = this.getCustomProperties(dataSourcePoolProps.getCustomProperties().getProperties(), connectionProps.getQueryProperties());
        return new LocalDataQueryResultRow(new Object[]{name, storageUnit.getStorageType().getType(), connectionProps.getHostname(), connectionProps.getPort(), connectionProps.getCatalog(), this.getStandardProperty(poolProps, "connectionTimeoutMilliseconds"), this.getStandardProperty(poolProps, "idleTimeoutMilliseconds"), this.getStandardProperty(poolProps, "maxLifetimeMilliseconds"), this.getStandardProperty(poolProps, "maxPoolSize"), this.getStandardProperty(poolProps, "minPoolSize"), this.getStandardProperty(poolProps, "readOnly"), customProps});
    }

    private Map<String, StorageUnit> getStorageUnits(ShowStorageUnitsStatement sqlStatement) {
        return this.getLikePattern(sqlStatement).map(optional -> this.database.getResourceMetaData().getStorageUnits().entrySet().stream().filter(entry -> optional.matcher((CharSequence)entry.getKey()).matches()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElseGet(() -> this.database.getResourceMetaData().getStorageUnits());
    }

    private Optional<Pattern> getLikePattern(ShowStorageUnitsStatement sqlStatement) {
        return sqlStatement.getLikePattern().map(optional -> Pattern.compile(RegexUtils.convertLikePatternToRegex((String)optional), 2));
    }

    private DataSourcePoolProperties getDataSourcePoolProperties(StorageUnit storageUnit) {
        DataSource dataSource = storageUnit.getDataSource();
        DataSourcePoolProperties result = DataSourcePoolPropertiesCreator.create((DataSource)(dataSource instanceof CatalogSwitchableDataSource ? ((CatalogSwitchableDataSource)dataSource).getDataSource() : dataSource));
        if (new DatabaseTypeRegistry(storageUnit.getStorageType()).getDialectDatabaseMetaData().isInstanceConnectionAvailable()) {
            for (Map.Entry entry : storageUnit.getDataSourcePoolProperties().getPoolPropertySynonyms().getStandardProperties().entrySet()) {
                if (null == entry.getValue()) continue;
                result.getPoolPropertySynonyms().getStandardProperties().put((String)entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private Map<String, Object> getCustomProperties(Map<String, Object> customProps, Properties queryProps) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(customProps);
        result.remove("dataSourceProperties");
        if (!queryProps.isEmpty()) {
            result.put("queryProperties", queryProps);
        }
        return result;
    }

    private String getStandardProperty(Map<String, Object> standardProps, String key) {
        return standardProps.containsKey(key) && null != standardProps.get(key) ? standardProps.get(key).toString() : "";
    }

    @Override
    public Class<ShowStorageUnitsStatement> getType() {
        return ShowStorageUnitsStatement.class;
    }

    @Override
    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

