/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.time;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLFractionalSeconds {
    private final int nanos;
    private final int fractionalSecondsPrecision;

    public MySQLFractionalSeconds(int columnMeta, MySQLPacketPayload payload) {
        this.fractionalSecondsPrecision = columnMeta;
        this.nanos = this.convertFractionalSecondsToNanos(payload);
    }

    private int convertFractionalSecondsToNanos(MySQLPacketPayload payload) {
        switch (this.fractionalSecondsPrecision) {
            case 1: 
            case 2: {
                return payload.readInt1() * 10000 * 1000;
            }
            case 3: 
            case 4: {
                return payload.getByteBuf().readUnsignedShort() * 100 * 1000;
            }
            case 5: 
            case 6: {
                return payload.getByteBuf().readUnsignedMedium() * 1000;
            }
        }
        return 0;
    }

    @Generated
    public int getNanos() {
        return this.nanos;
    }
}

