/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.oracle.metadata.data.loader;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.database.core.metadata.data.loader.DialectMetaDataLoader;
import org.apache.shardingsphere.infra.database.core.metadata.data.loader.MetaDataLoaderConnection;
import org.apache.shardingsphere.infra.database.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.ColumnMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.IndexMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.datatype.DataTypeLoader;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.TableType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class OracleMetaDataLoader
implements DialectMetaDataLoader {
    private static final String TABLE_META_DATA_SQL_NO_ORDER = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, NULLABLE, DATA_TYPE, COLUMN_ID, HIDDEN_COLUMN %s FROM ALL_TAB_COLS WHERE OWNER = ?";
    private static final String ORDER_BY_COLUMN_ID = " ORDER BY COLUMN_ID";
    private static final String TABLE_META_DATA_SQL = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, NULLABLE, DATA_TYPE, COLUMN_ID, HIDDEN_COLUMN %s FROM ALL_TAB_COLS WHERE OWNER = ? ORDER BY COLUMN_ID";
    private static final String TABLE_META_DATA_SQL_IN_TABLES = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, NULLABLE, DATA_TYPE, COLUMN_ID, HIDDEN_COLUMN %s FROM ALL_TAB_COLS WHERE OWNER = ? AND TABLE_NAME IN (%s) ORDER BY COLUMN_ID";
    private static final String VIEW_META_DATA_SQL = "SELECT VIEW_NAME FROM ALL_VIEWS WHERE OWNER = ? AND VIEW_NAME IN (%s)";
    private static final String INDEX_META_DATA_SQL = "SELECT OWNER AS TABLE_SCHEMA, TABLE_NAME, INDEX_NAME, UNIQUENESS FROM ALL_INDEXES WHERE OWNER = ? AND TABLE_NAME IN (%s)";
    private static final String PRIMARY_KEY_META_DATA_SQL = "SELECT A.OWNER AS TABLE_SCHEMA, A.TABLE_NAME AS TABLE_NAME, B.COLUMN_NAME AS COLUMN_NAME FROM ALL_CONSTRAINTS A INNER JOIN ALL_CONS_COLUMNS B ON A.CONSTRAINT_NAME = B.CONSTRAINT_NAME WHERE CONSTRAINT_TYPE = 'P' AND A.OWNER = '%s'";
    private static final String PRIMARY_KEY_META_DATA_SQL_IN_TABLES = "SELECT A.OWNER AS TABLE_SCHEMA, A.TABLE_NAME AS TABLE_NAME, B.COLUMN_NAME AS COLUMN_NAME FROM ALL_CONSTRAINTS A INNER JOIN ALL_CONS_COLUMNS B ON A.CONSTRAINT_NAME = B.CONSTRAINT_NAME WHERE CONSTRAINT_TYPE = 'P' AND A.OWNER = '%s' AND A.TABLE_NAME IN (%s)";
    private static final String INDEX_COLUMN_META_DATA_SQL = "SELECT COLUMN_NAME FROM ALL_IND_COLUMNS WHERE INDEX_OWNER = ? AND TABLE_NAME = ? AND INDEX_NAME = ?";
    private static final int COLLATION_START_MAJOR_VERSION = 12;
    private static final int COLLATION_START_MINOR_VERSION = 2;
    private static final int IDENTITY_COLUMN_START_MINOR_VERSION = 1;
    private static final int MAX_EXPRESSION_SIZE = 1000;

    public Collection<SchemaMetaData> load(MetaDataLoaderMaterial material) throws SQLException {
        LinkedList<TableMetaData> tableMetaDataList = new LinkedList<TableMetaData>();
        try (MetaDataLoaderConnection connection = new MetaDataLoaderConnection((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"Oracle"), material.getDataSource().getConnection());){
            tableMetaDataList.addAll(this.getTableMetaDataList((Connection)connection, connection.getSchema(), material.getActualTableNames()));
        }
        return Collections.singletonList(new SchemaMetaData(material.getDefaultSchemaName(), tableMetaDataList));
    }

    private Collection<TableMetaData> getTableMetaDataList(Connection connection, String schema, Collection<String> tableNames) throws SQLException {
        LinkedList<String> viewNames = new LinkedList<String>();
        HashMap<String, Collection<ColumnMetaData>> columnMetaDataMap = new HashMap<String, Collection<ColumnMetaData>>(tableNames.size(), 1.0f);
        HashMap<String, Collection<Object>> indexMetaDataMap = new HashMap<String, Collection<Object>>(tableNames.size(), 1.0f);
        for (List each : Lists.partition(new ArrayList<String>(tableNames), (int)1000)) {
            viewNames.addAll(this.loadViewNames(connection, each, schema));
            columnMetaDataMap.putAll(this.loadColumnMetaDataMap(connection, each, schema));
            indexMetaDataMap.putAll(this.loadIndexMetaData(connection, each, schema));
        }
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        for (Map.Entry entry : columnMetaDataMap.entrySet()) {
            result.add(new TableMetaData((String)entry.getKey(), (Collection)entry.getValue(), (Collection)indexMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList()), Collections.emptyList(), viewNames.contains(entry.getKey()) ? TableType.VIEW : TableType.TABLE));
        }
        return result;
    }

    private Collection<String> loadViewNames(Connection connection, Collection<String> tables, String schema) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getViewMetaDataSQL(tables));){
            preparedStatement.setString(1, schema);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
        }
        return result;
    }

    private String getViewMetaDataSQL(Collection<String> tableNames) {
        return String.format(VIEW_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<ColumnMetaData>> loadColumnMetaDataMap(Connection connection, Collection<String> tables, String schema) throws SQLException {
        HashMap<String, Collection<ColumnMetaData>> result = new HashMap<String, Collection<ColumnMetaData>>(tables.size(), 1.0f);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getTableMetaDataSQL(tables, connection.getMetaData()));){
            Map dataTypes = new DataTypeLoader().load(connection.getMetaData(), this.getType());
            Map<String, Collection<String>> tablePrimaryKeys = this.loadTablePrimaryKeys(connection, tables);
            preparedStatement.setString(1, schema);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    ColumnMetaData columnMetaData = this.loadColumnMetaData(dataTypes, resultSet, tablePrimaryKeys.getOrDefault(tableName, Collections.emptyList()), connection.getMetaData());
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(columnMetaData);
                }
            }
        }
        return result;
    }

    private ColumnMetaData loadColumnMetaData(Map<String, Integer> dataTypeMap, ResultSet resultSet, Collection<String> primaryKeys, DatabaseMetaData databaseMetaData) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String dataType = this.getOriginalDataType(resultSet.getString("DATA_TYPE"));
        boolean primaryKey = primaryKeys.contains(columnName);
        boolean generated = this.versionContainsIdentityColumn(databaseMetaData) && "YES".equals(resultSet.getString("IDENTITY_COLUMN"));
        String collation = this.versionContainsCollation(databaseMetaData) ? resultSet.getString("COLLATION") : null;
        boolean caseSensitive = null != collation && collation.endsWith("_CS");
        boolean isVisible = "NO".equals(resultSet.getString("HIDDEN_COLUMN"));
        boolean nullable = "Y".equals(resultSet.getString("NULLABLE"));
        Integer dataTypeCode = Optional.ofNullable(dataTypeMap.get(dataType)).orElse(1111);
        return new ColumnMetaData(columnName, dataTypeCode.intValue(), primaryKey, generated, caseSensitive, isVisible, false, nullable);
    }

    private String getOriginalDataType(String dataType) {
        int index = dataType.indexOf(40);
        if (index > 0) {
            return dataType.substring(0, index);
        }
        return dataType;
    }

    private String getTableMetaDataSQL(Collection<String> tables, DatabaseMetaData databaseMetaData) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(28);
        if (this.versionContainsIdentityColumn(databaseMetaData)) {
            stringBuilder.append(", IDENTITY_COLUMN");
        }
        if (this.versionContainsCollation(databaseMetaData)) {
            stringBuilder.append(", COLLATION");
        }
        String collation = stringBuilder.toString();
        return tables.isEmpty() ? String.format(TABLE_META_DATA_SQL, collation) : String.format(TABLE_META_DATA_SQL_IN_TABLES, collation, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private boolean versionContainsCollation(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseMajorVersion() >= 12 && databaseMetaData.getDatabaseMinorVersion() >= 2;
    }

    private boolean versionContainsIdentityColumn(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseMajorVersion() >= 12 && databaseMetaData.getDatabaseMinorVersion() >= 1;
    }

    private Map<String, Collection<IndexMetaData>> loadIndexMetaData(Connection connection, Collection<String> tableNames, String schema) throws SQLException {
        HashMap<String, Collection<IndexMetaData>> result = new HashMap<String, Collection<IndexMetaData>>(tableNames.size(), 1.0f);
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(tableNames));){
            preparedStatement.setString(1, schema);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String indexName = resultSet.getString("INDEX_NAME");
                    String tableName = resultSet.getString("TABLE_NAME");
                    boolean isUnique = "UNIQUE".equals(resultSet.getString("UNIQUENESS"));
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    IndexMetaData indexMetaData = new IndexMetaData(indexName);
                    indexMetaData.setUnique(isUnique);
                    indexMetaData.getColumns().addAll(this.loadIndexColumnNames(connection, tableName, indexName));
                    ((Collection)result.get(tableName)).add(indexMetaData);
                }
            }
        }
        return result;
    }

    private List<String> loadIndexColumnNames(Connection connection, String tableName, String indexName) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(INDEX_COLUMN_META_DATA_SQL);){
            preparedStatement.setString(1, connection.getSchema());
            preparedStatement.setString(2, tableName);
            preparedStatement.setString(3, indexName);
            LinkedList<String> result = new LinkedList<String>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                result.add(resultSet.getString("COLUMN_NAME"));
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
    }

    private String getIndexMetaDataSQL(Collection<String> tableNames) {
        return String.format(INDEX_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<String>> loadTablePrimaryKeys(Connection connection, Collection<String> tableNames) throws SQLException {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getPrimaryKeyMetaDataSQL(connection.getSchema(), tableNames));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                String tableName = resultSet.getString("TABLE_NAME");
                result.computeIfAbsent(tableName, key -> new LinkedList()).add(columnName);
            }
        }
        return result;
    }

    private String getPrimaryKeyMetaDataSQL(String schemaName, Collection<String> tables) {
        return tables.isEmpty() ? String.format(PRIMARY_KEY_META_DATA_SQL, schemaName) : String.format(PRIMARY_KEY_META_DATA_SQL_IN_TABLES, schemaName, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    public String getDatabaseType() {
        return "Oracle";
    }
}

