/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.route.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.route.engine.type.BroadcastRouteEngine;
import org.apache.shardingsphere.broadcast.route.engine.type.broadcast.BroadcastDatabaseBroadcastRoutingEngine;
import org.apache.shardingsphere.broadcast.route.engine.type.broadcast.BroadcastTableBroadcastRoutingEngine;
import org.apache.shardingsphere.broadcast.route.engine.type.ignore.BroadcastIgnoreRoutingEngine;
import org.apache.shardingsphere.broadcast.route.engine.type.unicast.BroadcastUnicastRoutingEngine;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CloseStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.CursorAvailable;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLUseStatement;

public final class BroadcastRouteEngineFactory {
    public static BroadcastRouteEngine newInstance(BroadcastRule broadcastRule, ShardingSphereDatabase database, QueryContext queryContext) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof TCLStatement) {
            return new BroadcastDatabaseBroadcastRoutingEngine();
        }
        if (sqlStatement instanceof DDLStatement) {
            if (sqlStatementContext instanceof CursorAvailable) {
                return BroadcastRouteEngineFactory.getCursorRouteEngine(broadcastRule, sqlStatementContext, queryContext.getConnectionContext());
            }
            return BroadcastRouteEngineFactory.getDDLRoutingEngine(broadcastRule, database, queryContext);
        }
        if (sqlStatement instanceof DALStatement) {
            return BroadcastRouteEngineFactory.getDALRoutingEngine(broadcastRule, queryContext);
        }
        if (sqlStatement instanceof DCLStatement) {
            return BroadcastRouteEngineFactory.getDCLRoutingEngine(broadcastRule, queryContext);
        }
        return BroadcastRouteEngineFactory.getDQLRoutingEngine(broadcastRule, queryContext);
    }

    private static BroadcastRouteEngine getCursorRouteEngine(BroadcastRule broadcastRule, SQLStatementContext sqlStatementContext, ConnectionContext connectionContext) {
        if (sqlStatementContext instanceof CloseStatementContext && ((CloseStatementContext)sqlStatementContext).getSqlStatement().isCloseAll()) {
            return new BroadcastDatabaseBroadcastRoutingEngine();
        }
        List<String> tableNames = sqlStatementContext instanceof TableAvailable ? (Collection)((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().stream().map(each -> each.getTableName().getIdentifier().getValue()).collect(Collectors.toSet()) : Collections.emptyList();
        return broadcastRule.isAllBroadcastTables(tableNames) ? new BroadcastUnicastRoutingEngine(sqlStatementContext, tableNames, connectionContext) : new BroadcastIgnoreRoutingEngine();
    }

    private static BroadcastRouteEngine getDDLRoutingEngine(BroadcastRule broadcastRule, ShardingSphereDatabase database, QueryContext queryContext) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        Collection<String> tableNames = BroadcastRouteEngineFactory.getTableNames(database, sqlStatementContext);
        if (broadcastRule.isAllBroadcastTables(tableNames)) {
            return new BroadcastTableBroadcastRoutingEngine(tableNames);
        }
        return new BroadcastIgnoreRoutingEngine();
    }

    private static Collection<String> getTableNames(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext) {
        List<String> tableNames;
        Collection<String> collection = tableNames = sqlStatementContext instanceof TableAvailable ? (Collection)((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().stream().map(each -> each.getTableName().getIdentifier().getValue()).collect(Collectors.toSet()) : Collections.emptyList();
        if (!tableNames.isEmpty()) {
            return tableNames;
        }
        return sqlStatementContext instanceof IndexAvailable ? BroadcastRouteEngineFactory.getTableNames(database, sqlStatementContext.getDatabaseType(), ((IndexAvailable)sqlStatementContext).getIndexes()) : Collections.emptyList();
    }

    private static Collection<String> getTableNames(ShardingSphereDatabase database, DatabaseType databaseType, Collection<IndexSegment> indexes) {
        LinkedList<String> result = new LinkedList<String>();
        for (QualifiedTable each : IndexMetaDataUtils.getTableNames((ShardingSphereDatabase)database, (DatabaseType)databaseType, indexes)) {
            result.add(each.getTableName());
        }
        return result;
    }

    private static BroadcastRouteEngine getDALRoutingEngine(BroadcastRule broadcastRule, QueryContext queryContext) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof MySQLUseStatement) {
            return new BroadcastIgnoreRoutingEngine();
        }
        Collection<String> tableNames = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getTableNames() : Collections.emptyList();
        Collection<String> broadcastRuleTableNames = broadcastRule.getBroadcastRuleTableNames(tableNames);
        if (broadcastRule.isAllBroadcastTables(broadcastRuleTableNames)) {
            return new BroadcastTableBroadcastRoutingEngine(broadcastRuleTableNames);
        }
        return new BroadcastIgnoreRoutingEngine();
    }

    private static BroadcastRouteEngine getDCLRoutingEngine(BroadcastRule broadcastRule, QueryContext queryContext) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        List<String> tableNames = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getTableNames() : Collections.emptyList();
        Collection<String> broadcastRuleTableNames = broadcastRule.getBroadcastRuleTableNames(tableNames);
        if (BroadcastRouteEngineFactory.isDCLForSingleTable(sqlStatementContext) && !broadcastRuleTableNames.isEmpty() || broadcastRule.isAllBroadcastTables(broadcastRuleTableNames)) {
            return new BroadcastTableBroadcastRoutingEngine(broadcastRuleTableNames);
        }
        return new BroadcastIgnoreRoutingEngine();
    }

    private static boolean isDCLForSingleTable(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof TableAvailable) {
            TableAvailable tableSegmentsAvailable = (TableAvailable)sqlStatementContext;
            return 1 == tableSegmentsAvailable.getTablesContext().getSimpleTables().size() && !"*".equals(((SimpleTableSegment)tableSegmentsAvailable.getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue());
        }
        return false;
    }

    private static BroadcastRouteEngine getDQLRoutingEngine(BroadcastRule broadcastRule, QueryContext queryContext) {
        List<String> tableNames;
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        Collection<String> collection = tableNames = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getTableNames() : Collections.emptyList();
        if (broadcastRule.isAllBroadcastTables(tableNames)) {
            return sqlStatementContext.getSqlStatement() instanceof SelectStatement ? new BroadcastUnicastRoutingEngine(sqlStatementContext, tableNames, queryContext.getConnectionContext()) : new BroadcastDatabaseBroadcastRoutingEngine();
        }
        return new BroadcastIgnoreRoutingEngine();
    }

    @Generated
    private BroadcastRouteEngineFactory() {
    }
}

