/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.PhysicalResourceAggregator;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.single.datanode.SingleTableDataNodeLoader;
import org.apache.shardingsphere.single.distsql.statement.rql.ShowUnloadedSingleTablesStatement;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.single.util.SingleTableLoadUtils;

public final class ShowUnloadedSingleTablesExecutor
implements DistSQLQueryExecutor<ShowUnloadedSingleTablesStatement>,
DistSQLExecutorDatabaseAware,
DistSQLExecutorRuleAware<SingleRule> {
    private ShardingSphereDatabase database;
    private SingleRule rule;

    public Collection<String> getColumnNames(ShowUnloadedSingleTablesStatement sqlStatement) {
        return Arrays.asList("table_name", "storage_unit_name");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowUnloadedSingleTablesStatement sqlStatement, ContextManager contextManager) {
        Map<String, Collection<DataNode>> actualDataNodes = this.getActualDataNodes(this.database);
        for (String each : ((TableMapperRuleAttribute)this.rule.getAttributes().getAttribute(TableMapperRuleAttribute.class)).getLogicTableNames()) {
            actualDataNodes.remove(each.toLowerCase());
        }
        return actualDataNodes.entrySet().stream().map(entry -> new LocalDataQueryResultRow(new Object[]{entry.getKey(), ((DataNode)((Collection)entry.getValue()).iterator().next()).getDataSourceName()})).collect(Collectors.toList());
    }

    private Map<String, Collection<DataNode>> getActualDataNodes(ShardingSphereDatabase database) {
        ResourceMetaData resourceMetaData = database.getResourceMetaData();
        Map aggregateDataSourceMap = PhysicalResourceAggregator.getAggregatedResources((Map)resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)), (Collection)database.getRuleMetaData().getRules());
        Collection excludedTables = SingleTableLoadUtils.getExcludedTables((Collection)database.getRuleMetaData().getRules());
        return SingleTableDataNodeLoader.load((String)database.getName(), (Map)aggregateDataSourceMap, (Collection)excludedTables);
    }

    public Class<SingleRule> getRuleClass() {
        return SingleRule.class;
    }

    public Class<ShowUnloadedSingleTablesStatement> getType() {
        return ShowUnloadedSingleTablesStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(SingleRule rule) {
        this.rule = rule;
    }
}

