/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.parameter.impl;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.route.context.RouteContext;

public final class ShardingPaginationParameterRewriter
implements ParameterRewriter,
RouteContextAware {
    private RouteContext routeContext;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getPaginationContext().isHasPagination() && !this.routeContext.isSingleRouting();
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        PaginationContext pagination = ((SelectStatementContext)sqlStatementContext).getPaginationContext();
        pagination.getOffsetParameterIndex().ifPresent(optional -> this.rewriteOffset(pagination, (int)optional, (StandardParameterBuilder)paramBuilder));
        pagination.getRowCountParameterIndex().ifPresent(optional -> this.rewriteRowCount(pagination, (int)optional, (StandardParameterBuilder)paramBuilder, sqlStatementContext));
    }

    private void rewriteOffset(PaginationContext pagination, int offsetParamIndex, StandardParameterBuilder paramBuilder) {
        paramBuilder.addReplacedParameters(offsetParamIndex, (Object)pagination.getRevisedOffset());
    }

    private void rewriteRowCount(PaginationContext pagination, int rowCountParamIndex, StandardParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext) {
        paramBuilder.addReplacedParameters(rowCountParamIndex, (Object)pagination.getRevisedRowCount((SelectStatementContext)sqlStatementContext));
    }

    @Generated
    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

