/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest.inventory;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.DialectInventoryColumnValueReader;

public final class OpenGaussInventoryColumnValueReader
implements DialectInventoryColumnValueReader {
    private static final String MONEY_TYPE = "money";
    private static final String BIT_TYPE = "bit";
    private static final String BOOL_TYPE = "bool";

    public Optional<Object> read(ResultSet resultSet, ResultSetMetaData metaData, int columnIndex) throws SQLException {
        if (this.isMoneyType(metaData, columnIndex)) {
            return Optional.ofNullable(resultSet.getBigDecimal(columnIndex));
        }
        if (this.isBitType(metaData, columnIndex)) {
            return Optional.ofNullable(resultSet.getString(columnIndex));
        }
        if (this.isBoolType(metaData, columnIndex)) {
            return Optional.of(resultSet.getBoolean(columnIndex));
        }
        return Optional.empty();
    }

    private boolean isMoneyType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return MONEY_TYPE.equalsIgnoreCase(metaData.getColumnTypeName(columnIndex));
    }

    private boolean isBoolType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return BOOL_TYPE.equalsIgnoreCase(metaData.getColumnTypeName(columnIndex));
    }

    private boolean isBitType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return -7 == metaData.getColumnType(columnIndex) && BIT_TYPE.equalsIgnoreCase(metaData.getColumnTypeName(columnIndex));
    }

    public String getDatabaseType() {
        return "openGauss";
    }
}

