/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.task.runner;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCancelingException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.finished.IngestFinishedPosition;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.PipelineJobProgressDetector;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransmissionTasksRunner
implements PipelineTasksRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransmissionTasksRunner.class);
    private final TransmissionJobItemContext jobItemContext;
    private final Collection<PipelineTask> inventoryTasks;
    private final Collection<PipelineTask> incrementalTasks;
    private final PipelineJobType jobType;
    private final PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager;

    public TransmissionTasksRunner(TransmissionJobItemContext jobItemContext) {
        this.jobItemContext = jobItemContext;
        this.inventoryTasks = jobItemContext.getInventoryTasks();
        this.incrementalTasks = jobItemContext.getIncrementalTasks();
        this.jobType = (PipelineJobType)TypedSPILoader.getService(PipelineJobType.class, (Object)PipelineJobIdUtils.parseJobType(jobItemContext.getJobId()).getType());
        this.jobItemManager = new PipelineJobItemManager(this.jobType.getYamlJobItemProgressSwapper());
    }

    @Override
    public void start() {
        ShardingSpherePreconditions.checkState((!this.jobItemContext.isStopping() ? 1 : 0) != 0, PipelineJobCancelingException::new);
        this.jobItemManager.persistProgress(this.jobItemContext);
        if (PipelineJobProgressDetector.isAllInventoryTasksFinished(this.inventoryTasks)) {
            log.info("All inventory tasks finished.");
            this.executeIncrementalTasks();
        } else {
            this.executeInventoryTasks();
        }
    }

    private synchronized void executeInventoryTasks() {
        this.updateJobItemStatus(JobStatus.EXECUTE_INVENTORY_TASK);
        LinkedList futures = new LinkedList();
        for (PipelineTask each : this.inventoryTasks) {
            if (each.getTaskProgress().getPosition() instanceof IngestFinishedPosition) continue;
            futures.addAll(each.start());
        }
        PipelineExecuteEngine.trigger(futures, new InventoryTaskExecuteCallback());
    }

    private synchronized void executeIncrementalTasks() {
        ShardingSpherePreconditions.checkState((!this.jobItemContext.isStopping() ? 1 : 0) != 0, PipelineJobCancelingException::new);
        if (this.incrementalTasks.isEmpty()) {
            log.info("Incremental tasks are empty, ignore.");
            return;
        }
        if (JobStatus.EXECUTE_INCREMENTAL_TASK == this.jobItemContext.getStatus()) {
            log.info("Incremental tasks had already run, ignore.");
            return;
        }
        this.updateJobItemStatus(JobStatus.EXECUTE_INCREMENTAL_TASK);
        LinkedList futures = new LinkedList();
        for (PipelineTask each : this.incrementalTasks) {
            if (each.getTaskProgress().getPosition() instanceof IngestFinishedPosition) continue;
            futures.addAll(each.start());
        }
        PipelineExecuteEngine.trigger(futures, new IncrementalExecuteCallback());
    }

    private void updateJobItemStatus(JobStatus jobStatus) {
        this.jobItemContext.setStatus(jobStatus);
        this.jobItemManager.updateStatus(this.jobItemContext.getJobId(), this.jobItemContext.getShardingItem(), jobStatus);
    }

    @Override
    public void stop() {
        this.jobItemContext.setStopping(true);
        for (PipelineTask each : this.inventoryTasks) {
            each.stop();
            QuietlyCloser.close((AutoCloseable)each);
        }
        for (PipelineTask each : this.incrementalTasks) {
            each.stop();
            QuietlyCloser.close((AutoCloseable)each);
        }
    }

    @Generated
    public TransmissionTasksRunner(TransmissionJobItemContext jobItemContext, Collection<PipelineTask> inventoryTasks, Collection<PipelineTask> incrementalTasks, PipelineJobType jobType, PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager) {
        this.jobItemContext = jobItemContext;
        this.inventoryTasks = inventoryTasks;
        this.incrementalTasks = incrementalTasks;
        this.jobType = jobType;
        this.jobItemManager = jobItemManager;
    }

    @Override
    @Generated
    public TransmissionJobItemContext getJobItemContext() {
        return this.jobItemContext;
    }

    private final class InventoryTaskExecuteCallback
    implements ExecuteCallback {
        private InventoryTaskExecuteCallback() {
        }

        @Override
        public void onSuccess() {
            ShardingSpherePreconditions.checkState((!TransmissionTasksRunner.this.jobItemContext.isStopping() ? 1 : 0) != 0, PipelineJobCancelingException::new);
            if (PipelineJobProgressDetector.isAllInventoryTasksFinished(TransmissionTasksRunner.this.inventoryTasks)) {
                log.info("onSuccess, all inventory tasks finished.");
                PipelineJobProgressPersistService.persistNow(TransmissionTasksRunner.this.jobItemContext.getJobId(), TransmissionTasksRunner.this.jobItemContext.getShardingItem());
                TransmissionTasksRunner.this.executeIncrementalTasks();
            } else {
                log.info("onSuccess, inventory tasks did not finish.");
            }
        }

        @Override
        public void onFailure(Throwable ignored) {
        }
    }

    private static final class IncrementalExecuteCallback
    implements ExecuteCallback {
        private IncrementalExecuteCallback() {
        }

        @Override
        public void onSuccess() {
            log.info("onSuccess, all incremental tasks finished.");
        }

        @Override
        public void onFailure(Throwable ignored) {
        }
    }
}

