/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.splitter;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.Range;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.type.StringPrimaryKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.type.UnsupportedKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.placeholder.IngestPlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataUtils;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.InventoryPositionCalculator;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.InventoryRecordsCountCalculator;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveIdentifier;

public final class InventoryDumperContextSplitter {
    private final PipelineDataSource sourceDataSource;
    private final InventoryDumperContext dumperContext;

    public Collection<InventoryDumperContext> split(TransmissionJobItemContext jobItemContext) {
        return this.splitByTable().stream().flatMap(each -> this.splitByPrimaryKey((InventoryDumperContext)each, jobItemContext).stream()).collect(Collectors.toList());
    }

    private Collection<InventoryDumperContext> splitByTable() {
        return this.dumperContext.getCommonContext().getTableNameMapper().getTableNameMap().entrySet().stream().map(entry -> this.createTableSpLitDumperContext((CaseInsensitiveIdentifier)entry.getKey(), (CaseInsensitiveIdentifier)entry.getValue())).collect(Collectors.toList());
    }

    private InventoryDumperContext createTableSpLitDumperContext(CaseInsensitiveIdentifier actualTableName, CaseInsensitiveIdentifier logicTableName) {
        InventoryDumperContext result = new InventoryDumperContext(this.dumperContext.getCommonContext());
        result.setActualTableName(actualTableName.toString());
        result.setLogicTableName(logicTableName.toString());
        result.getCommonContext().setPosition(new IngestPlaceholderPosition());
        result.setInsertColumnNames(this.dumperContext.getInsertColumnNames());
        result.setUniqueKeyColumns(this.dumperContext.getUniqueKeyColumns());
        return result;
    }

    private Collection<InventoryDumperContext> splitByPrimaryKey(InventoryDumperContext dumperContext, TransmissionJobItemContext jobItemContext) {
        if (null == dumperContext.getUniqueKeyColumns()) {
            dumperContext.setUniqueKeyColumns(this.getTableUniqueKeys(dumperContext, jobItemContext));
        }
        LinkedList<InventoryDumperContext> result = new LinkedList<InventoryDumperContext>();
        TransmissionProcessContext jobProcessContext = jobItemContext.getJobProcessContext();
        int batchSize = jobProcessContext.getProcessConfiguration().getRead().getBatchSize();
        JobRateLimitAlgorithm rateLimitAlgorithm = jobProcessContext.getReadRateLimitAlgorithm();
        int i = 0;
        for (IngestPosition each : this.getInventoryPositions(dumperContext, jobItemContext)) {
            result.add(this.createPrimaryKeySplitDumperContext(dumperContext, each, i++, batchSize, rateLimitAlgorithm));
        }
        return result;
    }

    private List<PipelineColumnMetaData> getTableUniqueKeys(InventoryDumperContext dumperContext, TransmissionJobItemContext jobItemContext) {
        String schemaName = dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(dumperContext.getLogicTableName());
        return PipelineTableMetaDataUtils.getUniqueKeyColumns(schemaName, dumperContext.getActualTableName(), jobItemContext.getSourceMetaDataLoader());
    }

    private Collection<IngestPosition> getInventoryPositions(InventoryDumperContext dumperContext, TransmissionJobItemContext jobItemContext) {
        Collection<IngestPosition> result;
        TransmissionJobItemProgress initProgress = jobItemContext.getInitProgress();
        if (null != initProgress && !(result = initProgress.getInventory().getInventoryPosition(dumperContext.getActualTableName()).values()).isEmpty()) {
            return result;
        }
        long tableRecordsCount = InventoryRecordsCountCalculator.getTableRecordsCount(dumperContext, this.sourceDataSource);
        jobItemContext.updateInventoryRecordsCount(tableRecordsCount);
        if (!dumperContext.hasUniqueKey()) {
            return Collections.singleton(new UnsupportedKeyIngestPosition());
        }
        List<PipelineColumnMetaData> uniqueKeyColumns = dumperContext.getUniqueKeyColumns();
        if (1 == uniqueKeyColumns.size()) {
            int firstColumnDataType = uniqueKeyColumns.get(0).getDataType();
            if (PipelineJdbcUtils.isIntegerColumn(firstColumnDataType)) {
                Range<Long> uniqueKeyValuesRange = this.getUniqueKeyValuesRange(jobItemContext, dumperContext);
                int shardingSize = jobItemContext.getJobProcessContext().getProcessConfiguration().getRead().getShardingSize();
                return InventoryPositionCalculator.getPositionByIntegerUniqueKeyRange(tableRecordsCount, uniqueKeyValuesRange, shardingSize);
            }
            if (PipelineJdbcUtils.isStringColumn(firstColumnDataType)) {
                return Collections.singleton(new StringPrimaryKeyIngestPosition(null, null));
            }
        }
        return Collections.singleton(new UnsupportedKeyIngestPosition());
    }

    /*
     * Exception decompiling
     */
    private Range<Long> getUniqueKeyValuesRange(TransmissionJobItemContext jobItemContext, InventoryDumperContext dumperContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InventoryDumperContext createPrimaryKeySplitDumperContext(InventoryDumperContext dumperContext, IngestPosition position, int shardingItem, int batchSize, JobRateLimitAlgorithm rateLimitAlgorithm) {
        InventoryDumperContext result = new InventoryDumperContext(dumperContext.getCommonContext());
        result.getCommonContext().setPosition(position);
        result.setShardingItem(shardingItem);
        result.setActualTableName(dumperContext.getActualTableName());
        result.setLogicTableName(dumperContext.getLogicTableName());
        result.setUniqueKeyColumns(dumperContext.getUniqueKeyColumns());
        result.setInsertColumnNames(dumperContext.getInsertColumnNames());
        result.setBatchSize(batchSize);
        result.setRateLimitAlgorithm(rateLimitAlgorithm);
        return result;
    }

    @Generated
    public InventoryDumperContextSplitter(PipelineDataSource sourceDataSource, InventoryDumperContext dumperContext) {
        this.sourceDataSource = sourceDataSource;
        this.dumperContext = dumperContext;
    }
}

