/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.exception.job.SplitPipelineJobByUniqueKeyException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelinePrepareSQLBuilder;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryRecordsCountCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryRecordsCountCalculator.class);

    public static long getTableRecordsCount(InventoryDumperContext dumperContext, PipelineDataSource dataSource) {
        String schemaName = dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(dumperContext.getLogicTableName());
        String actualTableName = dumperContext.getActualTableName();
        PipelinePrepareSQLBuilder pipelineSQLBuilder = new PipelinePrepareSQLBuilder(dataSource.getDatabaseType());
        Optional<String> sql = pipelineSQLBuilder.buildEstimatedCountSQL(schemaName, actualTableName);
        try {
            if (sql.isPresent() && dumperContext.getCommonContext().getDataSourceConfig() instanceof StandardPipelineDataSourceConfiguration) {
                DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)dataSource.getDatabaseType().getType());
                long result = InventoryRecordsCountCalculator.getEstimatedCount(databaseType, dataSource, sql.get());
                return result > 0L ? result : InventoryRecordsCountCalculator.getCount(dataSource, pipelineSQLBuilder.buildCountSQL(schemaName, actualTableName));
            }
            return InventoryRecordsCountCalculator.getCount(dataSource, pipelineSQLBuilder.buildCountSQL(schemaName, actualTableName));
        }
        catch (SQLException ex) {
            String uniqueKey = dumperContext.hasUniqueKey() ? dumperContext.getUniqueKeyColumns().get(0).getName() : "";
            throw new SplitPipelineJobByUniqueKeyException(dumperContext.getActualTableName(), uniqueKey, ex);
        }
    }

    /*
     * Exception decompiling
     */
    private static long getEstimatedCount(DatabaseType databaseType, DataSource dataSource, String estimatedCountSQL) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long getCount(DataSource dataSource, String countSQL) throws SQLException {
        long result;
        long startTimeMillis = System.currentTimeMillis();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(countSQL);
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            result = resultSet.getLong(1);
        }
        log.info("getCount cost {} ms, sql: {}, count: {}", new Object[]{System.currentTimeMillis() - startTimeMillis, countSQL, result});
        return result;
    }

    @Generated
    private InventoryRecordsCountCalculator() {
    }
}

