/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.DataConsistencyCheckUtils;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardPipelineTableMetaDataLoader
implements PipelineTableMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardPipelineTableMetaDataLoader.class);
    private final PipelineDataSource dataSource;
    private final Map<CaseInsensitiveIdentifier, PipelineTableMetaData> tableMetaDataMap = new ConcurrentHashMap<CaseInsensitiveIdentifier, PipelineTableMetaData>();

    @Override
    public PipelineTableMetaData getTableMetaData(String schemaName, String tableName) {
        PipelineTableMetaData result = this.tableMetaDataMap.get(new CaseInsensitiveIdentifier(tableName));
        if (null != result) {
            return result;
        }
        try {
            this.loadTableMetaData(schemaName, tableName);
        }
        catch (SQLException ex) {
            throw new PipelineInternalException(String.format("Load meta data for schema '%s' and table '%s' failed", schemaName, tableName), ex);
        }
        result = this.tableMetaDataMap.get(new CaseInsensitiveIdentifier(tableName));
        if (null == result) {
            log.warn("Can not load meta data for table '{}'", (Object)tableName);
        }
        return result;
    }

    private void loadTableMetaData(String schemaName, String tableNamePattern) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(this.dataSource.getDatabaseType()).getDialectDatabaseMetaData();
            Map<CaseInsensitiveIdentifier, PipelineTableMetaData> tableMetaDataMap = this.loadTableMetaData0(connection, dialectDatabaseMetaData.isSchemaAvailable() ? schemaName : null, tableNamePattern);
            this.tableMetaDataMap.putAll(tableMetaDataMap);
        }
    }

    private Map<CaseInsensitiveIdentifier, PipelineTableMetaData> loadTableMetaData0(Connection connection, String schemaName, String tableNamePattern) throws SQLException {
        LinkedList<String> tableNames = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), schemaName, tableNamePattern, null);){
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
        }
        LinkedHashMap<CaseInsensitiveIdentifier, PipelineTableMetaData> result = new LinkedHashMap<CaseInsensitiveIdentifier, PipelineTableMetaData>(tableNames.size(), 1.0f);
        for (String each : tableNames) {
            Collection<CaseInsensitiveIdentifier> primaryKeys = this.loadPrimaryKeys(connection, schemaName, each);
            Map<CaseInsensitiveIdentifier, Collection<CaseInsensitiveIdentifier>> uniqueKeys = this.loadUniqueIndexesOfTable(connection, schemaName, each);
            LinkedHashMap<CaseInsensitiveIdentifier, PipelineColumnMetaData> columnMetaDataMap = new LinkedHashMap<CaseInsensitiveIdentifier, PipelineColumnMetaData>();
            try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), schemaName, each, "%");){
                while (resultSet.next()) {
                    int ordinalPosition = resultSet.getInt("ORDINAL_POSITION");
                    CaseInsensitiveIdentifier columnName = new CaseInsensitiveIdentifier(resultSet.getString("COLUMN_NAME"));
                    if (columnMetaDataMap.containsKey(columnName)) continue;
                    int dataType = resultSet.getInt("DATA_TYPE");
                    String dataTypeName = resultSet.getString("TYPE_NAME");
                    boolean primaryKey = primaryKeys.contains(columnName);
                    boolean isNullable = "YES".equals(resultSet.getString("IS_NULLABLE"));
                    boolean isUniqueKey = uniqueKeys.values().stream().anyMatch(names -> names.contains(columnName));
                    PipelineColumnMetaData columnMetaData = new PipelineColumnMetaData(ordinalPosition, columnName.toString(), dataType, dataTypeName, isNullable, primaryKey, isUniqueKey);
                    columnMetaDataMap.put(columnName, columnMetaData);
                }
            }
            Collection uniqueIndexMetaData = uniqueKeys.entrySet().stream().map(entry -> new PipelineIndexMetaData((CaseInsensitiveIdentifier)entry.getKey(), ((Collection)entry.getValue()).stream().map(columnMetaDataMap::get).collect(Collectors.toList()), DataConsistencyCheckUtils.compareLists(primaryKeys, (Collection)entry.getValue()))).collect(Collectors.toList());
            result.put(new CaseInsensitiveIdentifier(each), new PipelineTableMetaData(each, columnMetaDataMap, uniqueIndexMetaData));
        }
        return result;
    }

    private Map<CaseInsensitiveIdentifier, Collection<CaseInsensitiveIdentifier>> loadUniqueIndexesOfTable(Connection connection, String schemaName, String tableName) throws SQLException {
        LinkedHashMap<String, SortedMap> orderedColumnsOfIndexes = new LinkedHashMap<String, SortedMap>();
        try (ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), schemaName, tableName, true, true);){
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                if (null == indexName) continue;
                orderedColumnsOfIndexes.computeIfAbsent(indexName, unused -> new TreeMap()).put(resultSet.getShort("ORDINAL_POSITION"), new CaseInsensitiveIdentifier(resultSet.getString("COLUMN_NAME")));
            }
        }
        LinkedHashMap<CaseInsensitiveIdentifier, Collection<CaseInsensitiveIdentifier>> result = new LinkedHashMap<CaseInsensitiveIdentifier, Collection<CaseInsensitiveIdentifier>>();
        for (Map.Entry entry : orderedColumnsOfIndexes.entrySet()) {
            Collection columnNames = result.computeIfAbsent(new CaseInsensitiveIdentifier((String)entry.getKey()), unused -> new LinkedList());
            columnNames.addAll(((SortedMap)entry.getValue()).values());
        }
        return result;
    }

    private Collection<CaseInsensitiveIdentifier> loadPrimaryKeys(Connection connection, String schemaName, String tableName) throws SQLException {
        TreeMap<Short, CaseInsensitiveIdentifier> result = new TreeMap<Short, CaseInsensitiveIdentifier>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), schemaName, tableName);){
            while (resultSet.next()) {
                result.put(resultSet.getShort("KEY_SEQ"), new CaseInsensitiveIdentifier(resultSet.getString("COLUMN_NAME")));
            }
        }
        return result.values();
    }

    @Generated
    public StandardPipelineTableMetaDataLoader(PipelineDataSource dataSource) {
        this.dataSource = dataSource;
    }
}

