/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.MatchingTableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryCheckParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.RecordSingleTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.SingleTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.annotation.SPIDescription;

@SPIDescription(value="Match raw data of records.")
public final class DataMatchTableDataConsistencyChecker
implements TableDataConsistencyChecker {
    private static final String CHUNK_SIZE_KEY = "chunk-size";
    private static final int DEFAULT_CHUNK_SIZE = 1000;
    private int chunkSize;

    public void init(Properties props) {
        this.chunkSize = this.getChunkSize(props);
    }

    private int getChunkSize(Properties props) {
        int result;
        String chunkSizeText = props.getProperty(CHUNK_SIZE_KEY);
        if (Strings.isNullOrEmpty((String)chunkSizeText)) {
            return 1000;
        }
        try {
            result = Integer.parseInt(chunkSizeText);
        }
        catch (NumberFormatException ignore) {
            throw new PipelineInvalidParameterException("'chunk-size' is not a valid number: `" + chunkSizeText + "`");
        }
        if (result <= 0) {
            throw new PipelineInvalidParameterException("Invalid 'chunk-size': " + result);
        }
        return result;
    }

    @Override
    public TableInventoryChecker buildTableInventoryChecker(TableInventoryCheckParameter param) {
        return new DataMatchTableInventoryChecker(param, this.chunkSize);
    }

    public Collection<DatabaseType> getSupportedDatabaseTypes() {
        return ShardingSphereServiceLoader.getServiceInstances(DatabaseType.class);
    }

    @Override
    public void close() {
    }

    public String getType() {
        return "DATA_MATCH";
    }

    private static final class DataMatchTableInventoryChecker
    extends MatchingTableInventoryChecker {
        private final int chunkSize;

        DataMatchTableInventoryChecker(TableInventoryCheckParameter param, int chunkSize) {
            super(param);
            this.chunkSize = chunkSize;
        }

        @Override
        protected SingleTableInventoryCalculator buildSingleTableInventoryCalculator() {
            return new RecordSingleTableInventoryCalculator(this.chunkSize);
        }
    }
}

