/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.result;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.DataConsistencyCheckUtils;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.SingleTableInventoryCalculatedResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordSingleTableInventoryCalculatedResult
implements SingleTableInventoryCalculatedResult {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecordSingleTableInventoryCalculatedResult.class);
    private final Object maxUniqueKeyValue;
    private final int recordsCount;
    private final List<Map<String, Object>> records;

    public RecordSingleTableInventoryCalculatedResult(Object maxUniqueKeyValue, List<Map<String, Object>> records) {
        this.maxUniqueKeyValue = maxUniqueKeyValue;
        this.recordsCount = records.size();
        this.records = records;
    }

    @Override
    public Optional<Object> getMaxUniqueKeyValue() {
        return Optional.of(this.maxUniqueKeyValue);
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordSingleTableInventoryCalculatedResult)) {
            log.warn("RecordSingleTableInventoryCalculatedResult type not match, o.className={}.", (Object)o.getClass().getName());
            return false;
        }
        RecordSingleTableInventoryCalculatedResult that = (RecordSingleTableInventoryCalculatedResult)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        if (this.recordsCount != that.recordsCount || !DataConsistencyCheckUtils.isMatched(equalsBuilder, this.maxUniqueKeyValue, that.maxUniqueKeyValue)) {
            log.warn("Record count or max unique key value not match, recordCount1={}, recordCount2={}, maxUniqueKeyValue1={}, maxUniqueKeyValue2={}, value1.class={}, value2.class={}.", new Object[]{this.recordsCount, that.recordsCount, this.maxUniqueKeyValue, that.maxUniqueKeyValue, null == this.maxUniqueKeyValue ? "" : this.maxUniqueKeyValue.getClass().getName(), null == that.maxUniqueKeyValue ? "" : that.maxUniqueKeyValue.getClass().getName()});
            return false;
        }
        Iterator<Map<String, Object>> thisRecordsIterator = this.records.iterator();
        Iterator<Map<String, Object>> thatRecordsIterator = that.records.iterator();
        while (thisRecordsIterator.hasNext() && thatRecordsIterator.hasNext()) {
            Map<String, Object> thisRecord = thisRecordsIterator.next();
            Map<String, Object> thatRecord = thatRecordsIterator.next();
            if (thisRecord.size() != thatRecord.size()) {
                log.warn("Record column size not match, size1={}, size2={}, record1={}, record2={}.", new Object[]{thisRecord.size(), thatRecord.size(), thisRecord, thatRecord});
                return false;
            }
            if (DataConsistencyCheckUtils.recordsEquals(thisRecord, thatRecord, equalsBuilder)) continue;
            log.warn("Records not equals, record1={}, record2={}.", thisRecord, thatRecord);
            return false;
        }
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.getMaxUniqueKeyValue().orElse(null)).append(this.getRecordsCount()).append(this.records).toHashCode();
    }

    @Override
    @Generated
    public int getRecordsCount() {
        return this.recordsCount;
    }

    @Generated
    public List<Map<String, Object>> getRecords() {
        return this.records;
    }
}

