/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinitionFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLFieldCountPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;

public final class ResponsePacketBuilder {
    private static final String BINARY_COLUMN_TYPE_KEYWORD = "BINARY";
    private static final String BLOB_COLUMN_TYPE_KEYWORD = "BLOB";

    public static Collection<DatabasePacket> buildQueryResponsePackets(QueryResponseHeader queryResponseHeader, int characterSet, int statusFlags) {
        LinkedList<DatabasePacket> result = new LinkedList<DatabasePacket>();
        List queryHeaders = queryResponseHeader.getQueryHeaders();
        result.add((DatabasePacket)new MySQLFieldCountPacket(queryHeaders.size()));
        for (QueryHeader each : queryHeaders) {
            result.add((DatabasePacket)new MySQLColumnDefinition41Packet(characterSet, ResponsePacketBuilder.getColumnDefinitionFlag(each), each.getSchema(), each.getTable(), each.getTable(), each.getColumnLabel(), each.getColumnName(), each.getColumnLength(), MySQLBinaryColumnType.valueOfJDBCType((int)each.getColumnType()), each.getDecimals(), false));
        }
        result.add((DatabasePacket)new MySQLEofPacket(statusFlags));
        return result;
    }

    private static int getColumnDefinitionFlag(QueryHeader header) {
        int result = 0;
        if (header.isPrimaryKey()) {
            result += MySQLColumnDefinitionFlag.PRIMARY_KEY.getValue();
        }
        if (header.isNotNull()) {
            result += MySQLColumnDefinitionFlag.NOT_NULL.getValue();
        }
        if (!header.isSigned()) {
            result += MySQLColumnDefinitionFlag.UNSIGNED.getValue();
        }
        if (header.isAutoIncrement()) {
            result += MySQLColumnDefinitionFlag.AUTO_INCREMENT.getValue();
        }
        if (header.getColumnTypeName().contains(BINARY_COLUMN_TYPE_KEYWORD) || header.getColumnTypeName().contains(BLOB_COLUMN_TYPE_KEYWORD)) {
            result += MySQLColumnDefinitionFlag.BINARY_COLLATION.getValue();
        }
        return result;
    }

    public static Collection<DatabasePacket> buildUpdateResponsePackets(UpdateResponseHeader updateResponseHeader, int serverStatusFlag) {
        return Collections.singleton(new MySQLOKPacket(updateResponseHeader.getUpdateCount(), updateResponseHeader.getLastInsertId(), serverStatusFlag));
    }

    @Generated
    private ResponsePacketBuilder() {
    }
}

