/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;

public final class MySQLComStmtPrepareParameterMarkerExtractor {
    public static List<ShardingSphereColumn> findColumnsOfParameterMarkers(SQLStatement sqlStatement, ShardingSphereSchema schema) {
        return sqlStatement instanceof InsertStatement ? MySQLComStmtPrepareParameterMarkerExtractor.findColumnsOfParameterMarkersForInsert((InsertStatement)sqlStatement, schema) : Collections.emptyList();
    }

    private static List<ShardingSphereColumn> findColumnsOfParameterMarkersForInsert(InsertStatement insertStatement, ShardingSphereSchema schema) {
        ShardingSphereTable table = schema.getTable(insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse(""));
        List<String> columnNamesOfInsert = MySQLComStmtPrepareParameterMarkerExtractor.getColumnNamesOfInsertStatement(insertStatement, table);
        ArrayList<ShardingSphereColumn> result = new ArrayList<ShardingSphereColumn>(insertStatement.getParameterMarkerSegments().size());
        for (InsertValuesSegment each : insertStatement.getValues()) {
            ListIterator listIterator = each.getValues().listIterator();
            int columnIndex = listIterator.nextIndex();
            while (listIterator.hasNext()) {
                ExpressionSegment value = (ExpressionSegment)listIterator.next();
                if (value instanceof ParameterMarkerExpressionSegment) {
                    String columnName = columnNamesOfInsert.get(columnIndex);
                    ShardingSphereColumn column = table.getColumn(columnName);
                    result.add(column);
                }
                columnIndex = listIterator.nextIndex();
            }
        }
        return result;
    }

    private static List<String> getColumnNamesOfInsertStatement(InsertStatement insertStatement, ShardingSphereTable table) {
        return insertStatement.getColumns().isEmpty() ? table.getColumnNames() : insertStatement.getColumns().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
    }

    @Generated
    private MySQLComStmtPrepareParameterMarkerExtractor() {
    }
}

