/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.authentication;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.authentication.Authenticator;
import org.apache.shardingsphere.authentication.AuthenticatorFactory;
import org.apache.shardingsphere.authentication.result.AuthenticationResult;
import org.apache.shardingsphere.authentication.result.AuthenticationResultBuilder;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.db.protocol.constant.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCapabilityFlag;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConnectionPhase;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLStatusFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthSwitchRequestPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthSwitchResponsePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthenticationPluginData;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLHandshakePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLHandshakeResponse41Packet;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.mysql.exception.AccessDeniedException;
import org.apache.shardingsphere.infra.exception.mysql.exception.DatabaseAccessDeniedException;
import org.apache.shardingsphere.infra.exception.mysql.exception.HandshakeException;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.connection.ConnectionIdGenerator;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.authenticator.MySQLAuthenticatorType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.MySQLStatementIdGenerator;
import org.apache.shardingsphere.proxy.frontend.mysql.ssl.MySQLSSLRequestHandler;
import org.apache.shardingsphere.proxy.frontend.ssl.ProxySSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLAuthenticationEngine
implements AuthenticationEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLAuthenticationEngine.class);
    private final MySQLAuthenticationPluginData authPluginData = new MySQLAuthenticationPluginData();
    private MySQLConnectionPhase connectionPhase = MySQLConnectionPhase.INITIAL_HANDSHAKE;
    private byte[] authResponse;
    private AuthenticationResult currentAuthResult;

    public int handshake(ChannelHandlerContext context) {
        int result = ConnectionIdGenerator.getInstance().nextId();
        this.connectionPhase = MySQLConnectionPhase.AUTH_PHASE_FAST_PATH;
        boolean sslEnabled = ProxySSLContext.getInstance().isSSLEnabled();
        if (sslEnabled) {
            context.pipeline().addFirst(MySQLSSLRequestHandler.class.getSimpleName(), (ChannelHandler)new MySQLSSLRequestHandler());
        }
        context.writeAndFlush((Object)new MySQLHandshakePacket(result, sslEnabled, this.authPluginData));
        MySQLStatementIdGenerator.getInstance().registerConnection(result);
        return result;
    }

    public AuthenticationResult authenticate(ChannelHandlerContext context, PacketPayload payload) {
        Grantee grantee;
        AuthorityRule rule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        if (MySQLConnectionPhase.AUTH_PHASE_FAST_PATH == this.connectionPhase) {
            this.currentAuthResult = this.authenticatePhaseFastPath(context, payload, rule);
            if (!this.currentAuthResult.isFinished()) {
                return this.currentAuthResult;
            }
        } else if (MySQLConnectionPhase.AUTHENTICATION_METHOD_MISMATCH == this.connectionPhase) {
            this.authenticateMismatchedMethod((MySQLPacketPayload)payload);
        }
        if (!this.login(rule, grantee = new Grantee(this.currentAuthResult.getUsername(), this.getHostAddress(context)), this.authResponse)) {
            throw new AccessDeniedException(this.currentAuthResult.getUsername(), grantee.getHostname(), 0 != this.authResponse.length);
        }
        if (!this.authorizeDatabase(rule, grantee, this.currentAuthResult.getDatabase())) {
            throw new DatabaseAccessDeniedException(this.currentAuthResult.getUsername(), grantee.getHostname(), this.currentAuthResult.getDatabase());
        }
        this.writeOKPacket(context);
        return AuthenticationResultBuilder.finished((String)grantee.getUsername(), (String)grantee.getHostname(), (String)this.currentAuthResult.getDatabase());
    }

    private AuthenticationResult authenticatePhaseFastPath(ChannelHandlerContext context, PacketPayload payload, AuthorityRule rule) {
        MySQLHandshakeResponse41Packet handshakeResponsePacket;
        try {
            handshakeResponsePacket = new MySQLHandshakeResponse41Packet((MySQLPacketPayload)payload);
        }
        catch (IndexOutOfBoundsException ex) {
            if (log.isWarnEnabled()) {
                log.warn("Received bad handshake from client {}: \n{}", (Object)context.channel(), (Object)ByteBufUtil.prettyHexDump((ByteBuf)payload.getByteBuf().resetReaderIndex()));
            }
            throw new HandshakeException();
        }
        this.authResponse = handshakeResponsePacket.getAuthResponse();
        this.setMultiStatementsOption(context, handshakeResponsePacket);
        this.setCharacterSet(context, handshakeResponsePacket);
        String database = handshakeResponsePacket.getDatabase();
        if (!Strings.isNullOrEmpty((String)database) && !ProxyContext.getInstance().databaseExists(database)) {
            throw new UnknownDatabaseException(database);
        }
        String username = handshakeResponsePacket.getUsername();
        String hostname = this.getHostAddress(context);
        ShardingSphereUser user = rule.findUser(new Grantee(username, hostname)).orElseGet(() -> new ShardingSphereUser(username, "", hostname));
        Authenticator authenticator = new AuthenticatorFactory(MySQLAuthenticatorType.class, rule).newInstance(user);
        if (0 == this.authResponse.length || this.isClientPluginAuthenticate(handshakeResponsePacket) && !authenticator.getAuthenticationMethodName().equals(handshakeResponsePacket.getAuthPluginName())) {
            this.connectionPhase = MySQLConnectionPhase.AUTHENTICATION_METHOD_MISMATCH;
            context.writeAndFlush((Object)new MySQLAuthSwitchRequestPacket(authenticator.getAuthenticationMethodName(), this.authPluginData));
            return AuthenticationResultBuilder.continued((String)username, (String)hostname, (String)database);
        }
        return AuthenticationResultBuilder.finished((String)username, (String)hostname, (String)database);
    }

    private void setMultiStatementsOption(ChannelHandlerContext context, MySQLHandshakeResponse41Packet handshakeResponsePacket) {
        context.channel().attr(MySQLConstants.OPTION_MULTI_STATEMENTS_ATTRIBUTE_KEY).set((Object)handshakeResponsePacket.getMultiStatementsOption());
    }

    private void setCharacterSet(ChannelHandlerContext context, MySQLHandshakeResponse41Packet handshakeResponsePacket) {
        MySQLCharacterSet characterSet = MySQLCharacterSet.findById((int)handshakeResponsePacket.getCharacterSet());
        context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)characterSet.getCharset());
        context.channel().attr(MySQLConstants.CHARACTER_SET_ATTRIBUTE_KEY).set((Object)characterSet);
    }

    private boolean isClientPluginAuthenticate(MySQLHandshakeResponse41Packet packet) {
        return 0 != (packet.getCapabilityFlags() & MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH.getValue());
    }

    private void authenticateMismatchedMethod(MySQLPacketPayload payload) {
        this.authResponse = new MySQLAuthSwitchResponsePacket(payload).getAuthPluginResponse();
    }

    private boolean login(AuthorityRule rule, Grantee grantee, byte[] authenticationResponse) {
        Optional user = rule.findUser(grantee);
        return user.isPresent() && new AuthenticatorFactory(MySQLAuthenticatorType.class, rule).newInstance((ShardingSphereUser)user.get()).authenticate((ShardingSphereUser)user.get(), new Object[]{authenticationResponse, this.authPluginData});
    }

    private boolean authorizeDatabase(AuthorityRule rule, Grantee grantee, String databaseName) {
        return null == databaseName || new AuthorityChecker(rule, grantee).isAuthorized(databaseName);
    }

    private String getHostAddress(ChannelHandlerContext context) {
        if (context.channel() instanceof EpollDomainSocketChannel) {
            return context.channel().parent().localAddress().toString();
        }
        SocketAddress socketAddress = context.channel().remoteAddress();
        return socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getAddress().getHostAddress() : socketAddress.toString();
    }

    private void writeOKPacket(ChannelHandlerContext context) {
        context.writeAndFlush((Object)new MySQLOKPacket(MySQLStatusFlag.SERVER_STATUS_AUTOCOMMIT.getValue()));
    }
}

