/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.tuple;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlGlobalRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.path.GlobalNodePath;
import org.apache.shardingsphere.mode.path.rule.RuleNodePath;
import org.apache.shardingsphere.mode.spi.RuleNodePathProvider;
import org.apache.shardingsphere.mode.tuple.RepositoryTuple;
import org.apache.shardingsphere.mode.tuple.annotation.RepositoryTupleEntity;
import org.apache.shardingsphere.mode.tuple.annotation.RepositoryTupleField;
import org.apache.shardingsphere.mode.tuple.annotation.RepositoryTupleKeyListNameGenerator;

public final class RepositoryTupleSwapperEngine {
    public Collection<RepositoryTuple> swapToRepositoryTuples(YamlRuleConfiguration yamlRuleConfig) {
        RepositoryTupleEntity tupleEntity = yamlRuleConfig.getClass().getAnnotation(RepositoryTupleEntity.class);
        if (null == tupleEntity) {
            return Collections.emptyList();
        }
        if (tupleEntity.leaf()) {
            return Collections.singleton(new RepositoryTuple(tupleEntity.value(), YamlEngine.marshal((Object)yamlRuleConfig)));
        }
        LinkedList<RepositoryTuple> result = new LinkedList<RepositoryTuple>();
        RuleNodePath ruleNodePath = ((RuleNodePathProvider)TypedSPILoader.getService(RuleNodePathProvider.class, (Object)yamlRuleConfig.getRuleConfigurationType())).getRuleNodePath();
        for (Field each : this.getFields(yamlRuleConfig.getClass())) {
            boolean isAccessible = each.isAccessible();
            each.setAccessible(true);
            result.addAll(this.swapToRepositoryTuples(yamlRuleConfig, ruleNodePath, each));
            each.setAccessible(isAccessible);
        }
        return result;
    }

    private Collection<RepositoryTuple> swapToRepositoryTuples(YamlRuleConfiguration yamlRuleConfig, RuleNodePath ruleNodePath, Field field) {
        Object fieldValue = field.get(yamlRuleConfig);
        if (null == fieldValue) {
            return Collections.emptyList();
        }
        String tupleName = this.getTupleName(field);
        RepositoryTupleKeyListNameGenerator tupleKeyListNameGenerator = field.getAnnotation(RepositoryTupleKeyListNameGenerator.class);
        if (null != tupleKeyListNameGenerator && fieldValue instanceof Collection) {
            LinkedList<RepositoryTuple> result = new LinkedList<RepositoryTuple>();
            for (Object value : (Collection)fieldValue) {
                String tupleKeyName = tupleKeyListNameGenerator.value().getConstructor(new Class[0]).newInstance(new Object[0]).generate(value);
                result.add(new RepositoryTuple(ruleNodePath.getNamedItem(tupleName).getPath(tupleKeyName), value.toString()));
            }
            return result;
        }
        if (fieldValue instanceof Map) {
            LinkedList<RepositoryTuple> result = new LinkedList<RepositoryTuple>();
            for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                result.add(new RepositoryTuple(ruleNodePath.getNamedItem(tupleName).getPath(entry.getKey().toString()), YamlEngine.marshal(entry.getValue())));
            }
            return result;
        }
        if (fieldValue instanceof Collection) {
            return ((Collection)fieldValue).isEmpty() ? Collections.emptyList() : Collections.singleton(new RepositoryTuple(ruleNodePath.getUniqueItem(tupleName).getPath(), YamlEngine.marshal((Object)fieldValue)));
        }
        if (fieldValue instanceof String) {
            return ((String)fieldValue).isEmpty() ? Collections.emptyList() : Collections.singleton(new RepositoryTuple(ruleNodePath.getUniqueItem(tupleName).getPath(), fieldValue.toString()));
        }
        if (fieldValue instanceof Boolean || fieldValue instanceof Integer || fieldValue instanceof Long) {
            return Collections.singleton(new RepositoryTuple(ruleNodePath.getUniqueItem(tupleName).getPath(), fieldValue.toString()));
        }
        if (fieldValue instanceof Enum) {
            return Collections.singleton(new RepositoryTuple(ruleNodePath.getUniqueItem(tupleName).getPath(), ((Enum)fieldValue).name()));
        }
        return Collections.singleton(new RepositoryTuple(ruleNodePath.getUniqueItem(tupleName).getPath(), YamlEngine.marshal((Object)fieldValue)));
    }

    private Collection<Field> getFields(Class<? extends YamlRuleConfiguration> yamlRuleConfigurationClass) {
        return Arrays.stream(yamlRuleConfigurationClass.getDeclaredFields()).filter(each -> null != each.getAnnotation(RepositoryTupleField.class)).sorted(Comparator.comparingInt(o -> o.getAnnotation(RepositoryTupleField.class).type().ordinal())).collect(Collectors.toList());
    }

    private String getTupleName(Field field) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
    }

    public Optional<YamlRuleConfiguration> swapToYamlRuleConfiguration(Collection<RepositoryTuple> repositoryTuples, Class<? extends YamlRuleConfiguration> toBeSwappedType) {
        RepositoryTupleEntity tupleEntity = toBeSwappedType.getAnnotation(RepositoryTupleEntity.class);
        if (null == tupleEntity) {
            return Optional.empty();
        }
        return tupleEntity.leaf() ? this.swapToYamlRuleConfiguration(repositoryTuples, toBeSwappedType, tupleEntity) : this.swapToYamlRuleConfiguration(repositoryTuples, toBeSwappedType, this.getFields(toBeSwappedType));
    }

    private Optional<YamlRuleConfiguration> swapToYamlRuleConfiguration(Collection<RepositoryTuple> repositoryTuples, Class<? extends YamlRuleConfiguration> toBeSwappedType, RepositoryTupleEntity tupleEntity) {
        if (YamlGlobalRuleConfiguration.class.isAssignableFrom(toBeSwappedType)) {
            for (RepositoryTuple each2 : repositoryTuples) {
                if (!GlobalNodePath.getVersion(tupleEntity.value(), each2.getKey()).isPresent()) continue;
                return Optional.of((YamlRuleConfiguration)YamlEngine.unmarshal((String)each2.getValue(), toBeSwappedType));
            }
            return Optional.empty();
        }
        YamlRuleConfiguration yamlRuleConfig = toBeSwappedType.getConstructor(new Class[0]).newInstance(new Object[0]);
        RuleNodePath ruleNodePath = ((RuleNodePathProvider)TypedSPILoader.getService(RuleNodePathProvider.class, (Object)yamlRuleConfig.getRuleConfigurationType())).getRuleNodePath();
        for (RepositoryTuple each3 : repositoryTuples.stream().filter(each -> ruleNodePath.getRoot().isValidatedPath(each.getKey())).collect(Collectors.toList())) {
            if (!ruleNodePath.getUniqueItem(tupleEntity.value()).isValidatedPath(each3.getKey())) continue;
            return Optional.of((YamlRuleConfiguration)YamlEngine.unmarshal((String)each3.getValue(), toBeSwappedType));
        }
        return Optional.empty();
    }

    private Optional<YamlRuleConfiguration> swapToYamlRuleConfiguration(Collection<RepositoryTuple> repositoryTuples, Class<? extends YamlRuleConfiguration> toBeSwappedType, Collection<Field> fields) {
        YamlRuleConfiguration yamlRuleConfig = toBeSwappedType.getConstructor(new Class[0]).newInstance(new Object[0]);
        RuleNodePath ruleNodePath = ((RuleNodePathProvider)TypedSPILoader.getService(RuleNodePathProvider.class, (Object)yamlRuleConfig.getRuleConfigurationType())).getRuleNodePath();
        List validTuples = repositoryTuples.stream().filter(each -> ruleNodePath.getRoot().isValidatedPath(each.getKey())).collect(Collectors.toList());
        if (validTuples.isEmpty()) {
            return Optional.empty();
        }
        for (RepositoryTuple each2 : validTuples) {
            if (Strings.isNullOrEmpty((String)each2.getValue())) continue;
            this.setFieldValue(yamlRuleConfig, fields, ruleNodePath, each2);
        }
        return Optional.of(yamlRuleConfig);
    }

    private void setFieldValue(YamlRuleConfiguration yamlRuleConfig, Collection<Field> fields, RuleNodePath ruleNodePath, RepositoryTuple repositoryTuple) {
        for (Field each : fields) {
            boolean isAccessible = each.isAccessible();
            each.setAccessible(true);
            this.setFieldValue(yamlRuleConfig, each, ruleNodePath, repositoryTuple);
            each.setAccessible(isAccessible);
        }
    }

    private void setFieldValue(YamlRuleConfiguration yamlRuleConfig, Field field, RuleNodePath ruleNodePath, RepositoryTuple repositoryTuple) throws IllegalAccessException {
        Object fieldValue = field.get(yamlRuleConfig);
        String tupleName = this.getTupleName(field);
        RepositoryTupleKeyListNameGenerator tupleKeyListNameGenerator = field.getAnnotation(RepositoryTupleKeyListNameGenerator.class);
        if (null != tupleKeyListNameGenerator && fieldValue instanceof Collection) {
            ruleNodePath.getNamedItem(tupleName).getName(repositoryTuple.getKey()).ifPresent(optional -> ((Collection)fieldValue).add(repositoryTuple.getValue()));
            return;
        }
        if (fieldValue instanceof Map) {
            Class valueClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
            ruleNodePath.getNamedItem(tupleName).getName(repositoryTuple.getKey()).ifPresent(optional -> ((Map)fieldValue).put(optional, YamlEngine.unmarshal((String)repositoryTuple.getValue(), (Class)valueClass)));
            return;
        }
        if (!ruleNodePath.getUniqueItem(tupleName).isValidatedPath(repositoryTuple.getKey())) {
            return;
        }
        if (fieldValue instanceof Collection) {
            field.set(yamlRuleConfig, YamlEngine.unmarshal((String)repositoryTuple.getValue(), List.class));
        } else if (field.getType().equals(String.class)) {
            field.set(yamlRuleConfig, repositoryTuple.getValue());
        } else if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
            field.set(yamlRuleConfig, Boolean.parseBoolean(repositoryTuple.getValue()));
        } else if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
            field.set(yamlRuleConfig, Integer.parseInt(repositoryTuple.getValue()));
        } else if (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
            field.set(yamlRuleConfig, Long.parseLong(repositoryTuple.getValue()));
        } else {
            field.set(yamlRuleConfig, YamlEngine.unmarshal((String)repositoryTuple.getValue(), field.getType()));
        }
    }

    public Collection<RuleConfiguration> swapToRuleConfigurations(Collection<RepositoryTuple> repositoryTuples) {
        if (repositoryTuples.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        YamlRuleConfigurationSwapperEngine yamlSwapperEngine = new YamlRuleConfigurationSwapperEngine();
        for (YamlRuleConfigurationSwapper each : OrderedSPILoader.getServices(YamlRuleConfigurationSwapper.class)) {
            Class<? extends YamlRuleConfiguration> yamlRuleConfigClass = this.getYamlRuleConfigurationClass(each);
            this.swapToYamlRuleConfiguration(repositoryTuples, yamlRuleConfigClass).ifPresent(optional -> result.add(yamlSwapperEngine.swapToRuleConfiguration(optional)));
        }
        return result;
    }

    public Optional<RuleConfiguration> swapToRuleConfiguration(String ruleTypeName, Collection<RepositoryTuple> repositoryTuples) {
        if (repositoryTuples.isEmpty()) {
            return Optional.empty();
        }
        YamlRuleConfigurationSwapperEngine yamlSwapperEngine = new YamlRuleConfigurationSwapperEngine();
        for (YamlRuleConfigurationSwapper each : ShardingSphereServiceLoader.getServiceInstances(YamlRuleConfigurationSwapper.class)) {
            Class<? extends YamlRuleConfiguration> yamlRuleConfigClass = this.getYamlRuleConfigurationClass(each);
            if (!ruleTypeName.equals(Objects.requireNonNull(yamlRuleConfigClass.getAnnotation(RepositoryTupleEntity.class)).value())) continue;
            Optional<YamlRuleConfiguration> yamlRuleConfig = this.swapToYamlRuleConfiguration(repositoryTuples, yamlRuleConfigClass);
            return yamlRuleConfig.map(arg_0 -> ((YamlRuleConfigurationSwapperEngine)yamlSwapperEngine).swapToRuleConfiguration(arg_0));
        }
        return Optional.empty();
    }

    private Class<? extends YamlRuleConfiguration> getYamlRuleConfigurationClass(YamlRuleConfigurationSwapper swapper) {
        return (Class)((ParameterizedType)swapper.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }
}

