/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.logging.yaml.swapper;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.logging.config.LoggingRuleConfiguration;
import org.apache.shardingsphere.logging.yaml.config.YamlLoggingRuleConfiguration;
import org.apache.shardingsphere.logging.yaml.swapper.YamlAppenderSwapper;
import org.apache.shardingsphere.logging.yaml.swapper.YamlLoggerSwapper;

public final class YamlLoggingRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlLoggingRuleConfiguration, LoggingRuleConfiguration> {
    private final YamlLoggerSwapper loggerSwapper = new YamlLoggerSwapper();
    private final YamlAppenderSwapper appenderSwapper = new YamlAppenderSwapper();

    public YamlLoggingRuleConfiguration swapToYamlConfiguration(LoggingRuleConfiguration data) {
        YamlLoggingRuleConfiguration result = new YamlLoggingRuleConfiguration();
        result.setLoggers(data.getLoggers().stream().map(this.loggerSwapper::swapToYamlConfiguration).collect(Collectors.toList()));
        result.setAppenders(data.getAppenders().stream().map(this.appenderSwapper::swapToYamlConfiguration).collect(Collectors.toList()));
        return result;
    }

    public LoggingRuleConfiguration swapToObject(YamlLoggingRuleConfiguration yamlConfig) {
        return new LoggingRuleConfiguration((Collection)yamlConfig.getLoggers().stream().map(this.loggerSwapper::swapToObject).collect(Collectors.toList()), (Collection)yamlConfig.getAppenders().stream().map(this.appenderSwapper::swapToObject).collect(Collectors.toList()));
    }

    public Class<LoggingRuleConfiguration> getTypeClass() {
        return LoggingRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "LOGGING";
    }

    public int getOrder() {
        return 9100;
    }
}

