/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.proxy.frontend.netty.CDCServerHandlerInitializer;

public final class CDCServer
implements Runnable {
    private final List<String> addressed;
    private final int port;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            List<ChannelFuture> futures = this.startInternal(this.addressed, this.port);
            for (ChannelFuture each : futures) {
                each.channel().closeFuture().sync();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.close();
        }
    }

    private List<ChannelFuture> startInternal(List<String> addresses, int port) throws InterruptedException {
        this.createEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x800000, 0x1000000))).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new CDCServerHandlerInitializer());
        ArrayList<ChannelFuture> result = new ArrayList<ChannelFuture>(addresses.size());
        for (String each : addresses) {
            result.add(bootstrap.bind(each, port).sync());
        }
        return result;
    }

    private void createEventLoopGroup() {
        this.bossGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(1) : new NioEventLoopGroup(1);
        this.workerGroup = Epoll.isAvailable() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
    }

    private void close() {
        if (null != this.bossGroup) {
            this.bossGroup.shutdownGracefully();
        }
        if (null != this.workerGroup) {
            this.workerGroup.shutdownGracefully();
        }
    }

    @Generated
    public CDCServer(List<String> addressed, int port) {
        this.addressed = addressed;
        this.port = port;
    }
}

