/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine;

import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public interface ShadowRouteEngine {
    public void route(RouteContext var1, ShadowRule var2);

    default public void decorateRouteContext(RouteContext routeContext, ShadowRule rule, Map<String, String> shadowDataSourceMappings) {
        LinkedList<RouteUnit> toBeRemovedRouteUnit = new LinkedList<RouteUnit>();
        LinkedList<RouteUnit> toBeAddedRouteUnit = new LinkedList<RouteUnit>();
        for (RouteUnit each : routeContext.getRouteUnits()) {
            String logicName = each.getDataSourceMapper().getLogicName();
            String actualName = each.getDataSourceMapper().getActualName();
            Optional<String> sourceDataSourceName = rule.getSourceDataSourceName(actualName);
            if (!sourceDataSourceName.isPresent()) continue;
            String shadowDataSourceName = shadowDataSourceMappings.get(sourceDataSourceName.get());
            toBeRemovedRouteUnit.add(each);
            toBeAddedRouteUnit.add(null == shadowDataSourceName ? new RouteUnit(new RouteMapper(logicName, sourceDataSourceName.get()), each.getTableMappers()) : new RouteUnit(new RouteMapper(logicName, shadowDataSourceName), each.getTableMappers()));
        }
        routeContext.getRouteUnits().removeAll(toBeRemovedRouteUnit);
        routeContext.getRouteUnits().addAll(toBeAddedRouteUnit);
    }
}

