/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.provider;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.constant.ShadowDistSQLConstants;

public final class ShadowRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<ShadowRuleConfiguration> {
    public String convert(ShadowRuleConfiguration ruleConfig) {
        if (ruleConfig.getDataSources().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder("CREATE SHADOW RULE");
        Iterator iterator = ruleConfig.getDataSources().iterator();
        while (iterator.hasNext()) {
            ShadowDataSourceConfiguration dataSourceConfig = (ShadowDataSourceConfiguration)iterator.next();
            String shadowRuleName = dataSourceConfig.getName();
            String shadowTables = this.getShadowTables(shadowRuleName, ruleConfig.getTables(), ruleConfig.getShadowAlgorithms());
            result.append(String.format(ShadowDistSQLConstants.SHADOW, shadowRuleName, dataSourceConfig.getProductionDataSourceName(), dataSourceConfig.getShadowDataSourceName(), shadowTables));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";");
        return result.toString();
    }

    private String getShadowTables(String shadowRuleName, Map<String, ShadowTableConfiguration> ruleConfig, Map<String, AlgorithmConfiguration> algorithmConfigs) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, ShadowTableConfiguration>> iterator = ruleConfig.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ShadowTableConfiguration> shadowTableConfig = iterator.next();
            if (shadowTableConfig.getValue().getDataSourceNames().contains(shadowRuleName)) {
                String shadowTableTypes = this.getShadowTableTypes(shadowTableConfig.getValue().getShadowAlgorithmNames(), algorithmConfigs);
                result.append(String.format("%s(%s)", shadowTableConfig.getKey(), shadowTableTypes));
            }
            if (!iterator.hasNext()) continue;
            result.append(",").append(System.lineSeparator());
        }
        return result.toString();
    }

    private String getShadowTableTypes(Collection<String> shadowAlgorithmNames, Map<String, AlgorithmConfiguration> algorithmConfigs) {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = shadowAlgorithmNames.iterator();
        while (iterator.hasNext()) {
            result.append(AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)algorithmConfigs.get(iterator.next())));
            if (!iterator.hasNext()) continue;
            result.append(",").append(' ');
        }
        return result.toString();
    }

    public Class<ShadowRuleConfiguration> getType() {
        return ShadowRuleConfiguration.class;
    }
}

